#include <LineoutAttributes.h>
#include <DataNode.h>
#include <Line.h>
#include <GlobalLineoutAttributes.h>

// ****************************************************************************
// Method: LineoutAttributes::LineoutAttributes
//
// Purpose: 
//   Constructor for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 23 09:21:57 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

LineoutAttributes::LineoutAttributes() : AttributeSubject("DDbbbibs")
{
    point1[0] = 0;
    point1[1] = 0;
    point1[2] = 0;
    point2[0] = 1;
    point2[1] = 1;
    point2[2] = 0;
    interactive = false;
    ignoreGlobal = false;
    samplingOn = false;
    numberOfSamplePoints = 50;
    reflineLabels = false;
}

// ****************************************************************************
// Method: LineoutAttributes::LineoutAttributes
//
// Purpose: 
//   Copy constructor for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 23 09:21:57 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

LineoutAttributes::LineoutAttributes(const LineoutAttributes &obj) : AttributeSubject("DDbbbibs")
{
    point1[0] = obj.point1[0];
    point1[1] = obj.point1[1];
    point1[2] = obj.point1[2];

    point2[0] = obj.point2[0];
    point2[1] = obj.point2[1];
    point2[2] = obj.point2[2];

    interactive = obj.interactive;
    ignoreGlobal = obj.ignoreGlobal;
    samplingOn = obj.samplingOn;
    numberOfSamplePoints = obj.numberOfSamplePoints;
    reflineLabels = obj.reflineLabels;
    designator = obj.designator;

    SelectAll();
}

// ****************************************************************************
// Method: LineoutAttributes::~LineoutAttributes
//
// Purpose: 
//   Destructor for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 23 09:21:57 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

LineoutAttributes::~LineoutAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: LineoutAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 23 09:21:57 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

LineoutAttributes& 
LineoutAttributes::operator = (const LineoutAttributes &obj)
{
    if (this == &obj) return *this;
    point1[0] = obj.point1[0];
    point1[1] = obj.point1[1];
    point1[2] = obj.point1[2];

    point2[0] = obj.point2[0];
    point2[1] = obj.point2[1];
    point2[2] = obj.point2[2];

    interactive = obj.interactive;
    ignoreGlobal = obj.ignoreGlobal;
    samplingOn = obj.samplingOn;
    numberOfSamplePoints = obj.numberOfSamplePoints;
    reflineLabels = obj.reflineLabels;
    designator = obj.designator;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: LineoutAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 23 09:21:57 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
LineoutAttributes::operator == (const LineoutAttributes &obj) const
{
    int i;

    // Compare the point1 arrays.
    bool point1_equal = true;
    for(i = 0; i < 3 && point1_equal; ++i)
        point1_equal = (point1[i] == obj.point1[i]);

    // Compare the point2 arrays.
    bool point2_equal = true;
    for(i = 0; i < 3 && point2_equal; ++i)
        point2_equal = (point2[i] == obj.point2[i]);

    // Create the return value
    return (point1_equal &&
            point2_equal &&
            (interactive == obj.interactive) &&
            (ignoreGlobal == obj.ignoreGlobal) &&
            (samplingOn == obj.samplingOn) &&
            (numberOfSamplePoints == obj.numberOfSamplePoints) &&
            (reflineLabels == obj.reflineLabels) &&
            (designator == obj.designator));
}

// ****************************************************************************
// Method: LineoutAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 23 09:21:57 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
LineoutAttributes::operator != (const LineoutAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: LineoutAttributes::TypeName
//
// Purpose: 
//   Type name method for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 23 09:21:57 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
LineoutAttributes::TypeName() const
{
    return "LineoutAttributes";
}

// ****************************************************************************
//
// Modifications:
//   Kathleen Bonnell, Thu Nov 18 17:46:02 PST 2004
//   Copy ReflineLabels.
//
//   Kathleen Bonnell, Tue Nov 23 09:19:32 PST 2004
//   Added ability to copy GlobalLineoutAttributes, as long as we aren't
//   ignoring them. 
//
// ****************************************************************************
bool
LineoutAttributes::CopyAttributes(const AttributeGroup *atts)
{
    bool retval = false;

    if(TypeName() == atts->TypeName())
    {
        // Call assignment operator.
        const LineoutAttributes *tmp = (const LineoutAttributes *)atts;
        *this = *tmp;
        retval = true;
    }
    else if(atts->TypeName() == "Line")
    {
        const Line *tmp = (const Line*)atts;
        SetPoint1(tmp->GetPoint1());
        SetPoint2(tmp->GetPoint2());
        SetDesignator(tmp->GetDesignator());
        SetNumberOfSamplePoints(tmp->GetNumSamples());
        retval = true;
    }
    else if(atts->TypeName() == "GlobalLineoutAttributes")
    {
        if (!ignoreGlobal)
        {
            const GlobalLineoutAttributes *tmp = 
                   (const GlobalLineoutAttributes*)atts;
            SetReflineLabels(tmp->GetCreateReflineLabels());
            SetSamplingOn(tmp->GetSamplingOn());
            SetNumberOfSamplePoints(tmp->GetNumSamples());
            retval = true;
        }
    }

    return retval;
}

AttributeSubject *
LineoutAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;

    if(TypeName() == tname)
    {
        retval = new LineoutAttributes(*this);
    }
    else if(tname == "Line")
    {
        Line *line = new Line;

        line->SetPoint1(GetPoint1());
        line->SetPoint2(GetPoint2());
        line->SetInteractive(GetInteractive());
        line->SetReflineLabels(GetReflineLabels());
        line->SetDesignator(GetDesignator());
        line->SetSamplingOn(GetSamplingOn());
        line->SetNumSamples(GetNumberOfSamplePoints());
        retval = line;
    }

    return retval;
}

// ****************************************************************************
// Method: LineoutAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 23 09:21:57 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LineoutAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new LineoutAttributes(*this);
    else
        retval = new LineoutAttributes;

    return retval;
}

// ****************************************************************************
// Method: LineoutAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 23 09:21:57 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
LineoutAttributes::SelectAll()
{
    Select(0, (void *)point1, 3);
    Select(1, (void *)point2, 3);
    Select(2, (void *)&interactive);
    Select(3, (void *)&ignoreGlobal);
    Select(4, (void *)&samplingOn);
    Select(5, (void *)&numberOfSamplePoints);
    Select(6, (void *)&reflineLabels);
    Select(7, (void *)&designator);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LineoutAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 23 09:21:57 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
LineoutAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    LineoutAttributes defaultObject;
    bool addToParent = false;
    // Create a node for LineoutAttributes.
    DataNode *node = new DataNode("LineoutAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("point1", point1, 3));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("point2", point2, 3));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("interactive", interactive));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("ignoreGlobal", ignoreGlobal));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("samplingOn", samplingOn));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numberOfSamplePoints", numberOfSamplePoints));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("reflineLabels", reflineLabels));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("designator", designator));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: LineoutAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 23 09:21:57 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
LineoutAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("LineoutAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("point1")) != 0)
        SetPoint1(node->AsDoubleArray());
    if((node = searchNode->GetNode("point2")) != 0)
        SetPoint2(node->AsDoubleArray());
    if((node = searchNode->GetNode("interactive")) != 0)
        SetInteractive(node->AsBool());
    if((node = searchNode->GetNode("ignoreGlobal")) != 0)
        SetIgnoreGlobal(node->AsBool());
    if((node = searchNode->GetNode("samplingOn")) != 0)
        SetSamplingOn(node->AsBool());
    if((node = searchNode->GetNode("numberOfSamplePoints")) != 0)
        SetNumberOfSamplePoints(node->AsInt());
    if((node = searchNode->GetNode("reflineLabels")) != 0)
        SetReflineLabels(node->AsBool());
    if((node = searchNode->GetNode("designator")) != 0)
        SetDesignator(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
LineoutAttributes::SetPoint1(const double *point1_)
{
    point1[0] = point1_[0];
    point1[1] = point1_[1];
    point1[2] = point1_[2];
    Select(0, (void *)point1, 3);
}

void
LineoutAttributes::SetPoint2(const double *point2_)
{
    point2[0] = point2_[0];
    point2[1] = point2_[1];
    point2[2] = point2_[2];
    Select(1, (void *)point2, 3);
}

void
LineoutAttributes::SetInteractive(bool interactive_)
{
    interactive = interactive_;
    Select(2, (void *)&interactive);
}

void
LineoutAttributes::SetIgnoreGlobal(bool ignoreGlobal_)
{
    ignoreGlobal = ignoreGlobal_;
    Select(3, (void *)&ignoreGlobal);
}

void
LineoutAttributes::SetSamplingOn(bool samplingOn_)
{
    samplingOn = samplingOn_;
    Select(4, (void *)&samplingOn);
}

void
LineoutAttributes::SetNumberOfSamplePoints(int numberOfSamplePoints_)
{
    numberOfSamplePoints = numberOfSamplePoints_;
    Select(5, (void *)&numberOfSamplePoints);
}

void
LineoutAttributes::SetReflineLabels(bool reflineLabels_)
{
    reflineLabels = reflineLabels_;
    Select(6, (void *)&reflineLabels);
}

void
LineoutAttributes::SetDesignator(const std::string &designator_)
{
    designator = designator_;
    Select(7, (void *)&designator);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
LineoutAttributes::GetPoint1() const
{
    return point1;
}

double *
LineoutAttributes::GetPoint1()
{
    return point1;
}

const double *
LineoutAttributes::GetPoint2() const
{
    return point2;
}

double *
LineoutAttributes::GetPoint2()
{
    return point2;
}

bool
LineoutAttributes::GetInteractive() const
{
    return interactive;
}

bool
LineoutAttributes::GetIgnoreGlobal() const
{
    return ignoreGlobal;
}

bool
LineoutAttributes::GetSamplingOn() const
{
    return samplingOn;
}

int
LineoutAttributes::GetNumberOfSamplePoints() const
{
    return numberOfSamplePoints;
}

bool
LineoutAttributes::GetReflineLabels() const
{
    return reflineLabels;
}

const std::string &
LineoutAttributes::GetDesignator() const
{
    return designator;
}

std::string &
LineoutAttributes::GetDesignator()
{
    return designator;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
LineoutAttributes::SelectPoint1()
{
    Select(0, (void *)point1, 3);
}

void
LineoutAttributes::SelectPoint2()
{
    Select(1, (void *)point2, 3);
}

void
LineoutAttributes::SelectDesignator()
{
    Select(7, (void *)&designator);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LineoutAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 23 09:21:57 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
LineoutAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Point 1";
        case 1:  return "Point 2";
        case 2:  return "Interactive";
        case 3:  return "ignoreGlobal";
        case 4:  return "samplingOn";
        case 5:  return "Number of Sample Points ";
        case 6:  return "Refline Labels";
        case 7:  return "Designator";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LineoutAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 23 09:21:57 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
LineoutAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_doubleArray;
        case 1:  return FieldType_doubleArray;
        case 2:  return FieldType_bool;
        case 3:  return FieldType_bool;
        case 4:  return FieldType_bool;
        case 5:  return FieldType_int;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_string;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: LineoutAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 23 09:21:57 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
LineoutAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "doubleArray";
        case 1:  return "doubleArray";
        case 2:  return "bool";
        case 3:  return "bool";
        case 4:  return "bool";
        case 5:  return "int";
        case 6:  return "bool";
        case 7:  return "string";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LineoutAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 23 09:21:57 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
LineoutAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const LineoutAttributes &obj = *((const LineoutAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        // Compare the point1 arrays.
        bool point1_equal = true;
        for(i = 0; i < 3 && point1_equal; ++i)
            point1_equal = (point1[i] == obj.point1[i]);

        retval = point1_equal;
        }
        break;
    case 1:
        {  // new scope
        // Compare the point2 arrays.
        bool point2_equal = true;
        for(i = 0; i < 3 && point2_equal; ++i)
            point2_equal = (point2[i] == obj.point2[i]);

        retval = point2_equal;
        }
        break;
    case 2:
        {  // new scope
        retval = (interactive == obj.interactive);
        }
        break;
    case 3:
        {  // new scope
        retval = (ignoreGlobal == obj.ignoreGlobal);
        }
        break;
    case 4:
        {  // new scope
        retval = (samplingOn == obj.samplingOn);
        }
        break;
    case 5:
        {  // new scope
        retval = (numberOfSamplePoints == obj.numberOfSamplePoints);
        }
        break;
    case 6:
        {  // new scope
        retval = (reflineLabels == obj.reflineLabels);
        }
        break;
    case 7:
        {  // new scope
        retval = (designator == obj.designator);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

void
LineoutAttributes::Print(ostream &out, bool selected_only) const
{
    out << "LineoutAttributes" << "\n";
    out << "{";
    const double *pt;
    int i;
    for(i = 0; i < NumAttributes(); ++i)
    {
        if(selected_only && !IsSelected(i))
            continue;

        switch(i)
        {
          case  0: pt = GetPoint1();
                   out << "point1=" << pt[0] << " " 
                                    << pt[1] << " "
                                    << pt[2] << endl;          break;
          case  1: pt = GetPoint2();
                   out << "point2=" << pt[0] << " " 
                                    << pt[1] << " "
                                    << pt[2] << endl;          break;
          case  2: out << "sampling on? " << GetSamplingOn();  break;
          case  3: out << "numberOfSamplePoints=" 
                       << GetNumberOfSamplePoints();    break;
        }
        out << ",";
    }

    out << "}";

}

