#include <PyIsovolumeAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyIsovolumeAttributes
//
// Purpose: 
//   This class contains attributes for the isovolume operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Jan 30 14:50:25 PST 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a IsovolumeAttributes.
//
struct IsovolumeAttributesObject
{
    PyObject_HEAD
    IsovolumeAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewIsovolumeAttributes();

static PyObject *
IsovolumeAttributes_Notify(PyObject *self, PyObject *args)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IsovolumeAttributes_SetLbound(PyObject *self, PyObject *args)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the lbound in the object.
    obj->data->SetLbound(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IsovolumeAttributes_GetLbound(PyObject *self, PyObject *args)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetLbound());
    return retval;
}

static PyObject *
IsovolumeAttributes_SetUbound(PyObject *self, PyObject *args)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the ubound in the object.
    obj->data->SetUbound(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IsovolumeAttributes_GetUbound(PyObject *self, PyObject *args)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetUbound());
    return retval;
}

static PyObject *
IsovolumeAttributes_SetVariable(PyObject *self, PyObject *args)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the variable in the object.
    obj->data->SetVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IsovolumeAttributes_GetVariable(PyObject *self, PyObject *args)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVariable().c_str());
    return retval;
}



static struct PyMethodDef IsovolumeAttributes_methods[] = {
    {"Notify", IsovolumeAttributes_Notify, METH_VARARGS},
    {"SetLbound", IsovolumeAttributes_SetLbound, METH_VARARGS},
    {"GetLbound", IsovolumeAttributes_GetLbound, METH_VARARGS},
    {"SetUbound", IsovolumeAttributes_SetUbound, METH_VARARGS},
    {"GetUbound", IsovolumeAttributes_GetUbound, METH_VARARGS},
    {"SetVariable", IsovolumeAttributes_SetVariable, METH_VARARGS},
    {"GetVariable", IsovolumeAttributes_GetVariable, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
IsovolumeAttributes_dealloc(PyObject *v)
{
   IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
IsovolumeAttributes_compare(PyObject *v, PyObject *w)
{
    IsovolumeAttributes *a = ((IsovolumeAttributesObject *)v)->data;
    IsovolumeAttributes *b = ((IsovolumeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
IsovolumeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "lbound") == 0)
        return IsovolumeAttributes_GetLbound(self, NULL);
    if(strcmp(name, "ubound") == 0)
        return IsovolumeAttributes_GetUbound(self, NULL);
    if(strcmp(name, "variable") == 0)
        return IsovolumeAttributes_GetVariable(self, NULL);

    return Py_FindMethod(IsovolumeAttributes_methods, self, name);
}

static int
IsovolumeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "lbound") == 0)
        retval = (IsovolumeAttributes_SetLbound(self, tuple) != NULL);
    else if(strcmp(name, "ubound") == 0)
        retval = (IsovolumeAttributes_SetUbound(self, tuple) != NULL);
    else if(strcmp(name, "variable") == 0)
        retval = (IsovolumeAttributes_SetVariable(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
IsovolumeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)v;

    fprintf(fp, "lbound = %g\n", obj->data->GetLbound());
    fprintf(fp, "ubound = %g\n", obj->data->GetUbound());
    fprintf(fp, "variable = \"%s\"\n", obj->data->GetVariable().c_str());

    return 0;
}

//
// The doc string for the class.
//
static char *IsovolumeAttributes_Purpose = "This class contains attributes for the isovolume operator.";

//
// The type description structure
//
static PyTypeObject IsovolumeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "IsovolumeAttributes",                    // tp_name
    sizeof(IsovolumeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)IsovolumeAttributes_dealloc,  // tp_dealloc
    (printfunc)IsovolumeAttributes_print,     // tp_print
    (getattrfunc)IsovolumeAttributes_getattr, // tp_getattr
    (setattrfunc)IsovolumeAttributes_setattr, // tp_setattr
    (cmpfunc)IsovolumeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    IsovolumeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static IsovolumeAttributes *defaultAtts = 0;

static PyObject *
NewIsovolumeAttributes()
{
    IsovolumeAttributesObject *newObject;
    newObject = PyObject_NEW(IsovolumeAttributesObject, &IsovolumeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new IsovolumeAttributes(*defaultAtts);
    else
        newObject->data = new IsovolumeAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapIsovolumeAttributes(const IsovolumeAttributes *attr)
{
    IsovolumeAttributesObject *newObject;
    newObject = PyObject_NEW(IsovolumeAttributesObject, &IsovolumeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (IsovolumeAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
IsovolumeAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewIsovolumeAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef IsovolumeAttributesMethods[] = {
    {"IsovolumeAttributes", IsovolumeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *IsovolumeAttributesObserver = 0;
static bool IsovolumeAttributesEnableLogging = true;

static void
PyIsovolumeAttributes_WriteLog(Subject *subj, void *data)
{
    IsovolumeAttributes *atts = (IsovolumeAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!IsovolumeAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# IsovolumeAttributes_WriteLog()\n");
}

void
PyIsovolumeAttributes_StartUp(IsovolumeAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyIsovolumeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(IsovolumeAttributesObserver == 0)
    {
        IsovolumeAttributesObserver = new ObserverToCallback(subj,
            PyIsovolumeAttributes_WriteLog, (void *)logFile);
    }

    IsovolumeAttributesEnableLogging = true;
}

void
PyIsovolumeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete IsovolumeAttributesObserver;
    IsovolumeAttributesObserver = 0;
}

PyMethodDef *
PyIsovolumeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return IsovolumeAttributesMethods;
}

bool
PyIsovolumeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &IsovolumeAttributesType);
}

IsovolumeAttributes *
PyIsovolumeAttributes_FromPyObject(PyObject *obj)
{
    IsovolumeAttributesObject *obj2 = (IsovolumeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyIsovolumeAttributes_NewPyObject()
{
    return NewIsovolumeAttributes();
}

PyObject *
PyIsovolumeAttributes_WrapPyObject(const IsovolumeAttributes *attr)
{
    return WrapIsovolumeAttributes(attr);
}

void
PyIsovolumeAttributes_SetLogging(bool val)
{
    IsovolumeAttributesEnableLogging = val;
}

void
PyIsovolumeAttributes_SetDefaults(const IsovolumeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new IsovolumeAttributes(*atts);
}

