// ************************************************************************* //
//  File: IsovolumeViewerPluginInfo.C
// ************************************************************************* //

#include <IsovolumePluginInfo.h>
#include <IsovolumeAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Isovolume_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Isovolume operator.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:49 PST 2004
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    IsovolumeViewerPluginInfo::InitializeGlobalObjects();
    return new IsovolumeViewerPluginInfo;
}

//
// Storage for static data elements.
//
IsovolumeAttributes *IsovolumeViewerPluginInfo::clientAtts = NULL;
IsovolumeAttributes *IsovolumeViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  IsovolumeViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:49 PST 2004
//
// ****************************************************************************
void
IsovolumeViewerPluginInfo::InitializeGlobalObjects()
{
    IsovolumeViewerPluginInfo::clientAtts  = new IsovolumeAttributes;
    IsovolumeViewerPluginInfo::defaultAtts = new IsovolumeAttributes;
}

// ****************************************************************************
//  Method: IsovolumeViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:49 PST 2004
//
// ****************************************************************************

AttributeSubject *
IsovolumeViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: IsovolumeViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:49 PST 2004
//
// ****************************************************************************

AttributeSubject *
IsovolumeViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: IsovolumeViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:49 PST 2004
//
// ****************************************************************************

void
IsovolumeViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(IsovolumeAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: IsovolumeViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:49 PST 2004
//
// ****************************************************************************

void
IsovolumeViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(IsovolumeAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: IsovolumeViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:49 PST 2004
//
// ****************************************************************************

void
IsovolumeViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(IsovolumeAttributes*)atts = *defaultAtts;
    else
        *(IsovolumeAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: IsovolumeViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:49 PST 2004
//
// ****************************************************************************

#include <Isovolume.xpm>
const char **
IsovolumeViewerPluginInfo::XPMIconData() const
{
    return Isovolume_xpm;
}
