// ************************************************************************* //
//                        IsovolumeScriptingPluginInfo.C
// ************************************************************************* //
#include <IsovolumePluginInfo.h>
#include <PyIsovolumeAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Isovolume_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Isovolume plot.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:50 PST 2004
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new IsovolumeScriptingPluginInfo;
}

// ****************************************************************************
// Method: IsovolumeScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
IsovolumeScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyIsovolumeAttributes_StartUp((IsovolumeAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: IsovolumeScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void *
IsovolumeScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyIsovolumeAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: IsovolumeScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Isovolume plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
IsovolumeScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyIsovolumeAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: IsovolumeScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
IsovolumeScriptingPluginInfo::SetLogging(bool val)
{
    PyIsovolumeAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: IsovolumeScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
IsovolumeScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyIsovolumeAttributes_SetDefaults((const IsovolumeAttributes *)atts);
}
