// ************************************************************************* //
//  File: IsovolumePluginInfo.h
// ************************************************************************* //

#ifndef ISOVOLUME_PLUGIN_INFO_H
#define ISOVOLUME_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class IsovolumeAttributes;

// ****************************************************************************
//  Class: IsovolumePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Isovolume operator
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:47 PST 2004
//
//  Modifications:
//
// ****************************************************************************

class IsovolumeGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
};

class IsovolumeCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual IsovolumeGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class IsovolumeGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual IsovolumeCommonPluginInfo
{
  public:
    virtual const char *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class IsovolumeViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual IsovolumeCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const ViewerPlot *plot,
                                        const bool fromDefault);
    virtual const char **XPMIconData() const;

    static void InitializeGlobalObjects();
  private:
    static IsovolumeAttributes *defaultAtts;
    static IsovolumeAttributes *clientAtts;
};

class IsovolumeEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual IsovolumeCommonPluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class IsovolumeScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual IsovolumeCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, FILE *log);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual void SetLogging(bool val);
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
