// ************************************************************************* //
//  File: IsovolumeGUIPluginInfo.C
// ************************************************************************* //

#include <IsovolumePluginInfo.h>
#include <IsovolumeAttributes.h>
#include <QvisIsovolumeWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Isovolume_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Isovolume operator.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:49 PST 2004
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new IsovolumeGUIPluginInfo;
}

// ****************************************************************************
//  Method: IsovolumeGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:49 PST 2004
//
// ****************************************************************************

const char *
IsovolumeGUIPluginInfo::GetMenuName() const
{
    return "Isovolume";
}


// ****************************************************************************
//  Method: IsovolumeGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:49 PST 2004
//
// ****************************************************************************

QvisPostableWindowObserver *
IsovolumeGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisIsovolumeWindow(type, (IsovolumeAttributes *)attr,
        "Isovolume operator attributes", "Isovolume operator", notepad);
}

// ****************************************************************************
//  Method: IsovolumeGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Jan 30 15:10:49 PST 2004
//
// ****************************************************************************

#include <Isovolume.xpm>
const char **
IsovolumeGUIPluginInfo::XPMIconData() const
{
    return Isovolume_xpm;
}
