package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: IsovolumeAttributes
//
// Purpose:
//    This class contains attributes for the isovolume operator.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Fri Jan 30 14:50:27 PST 2004
//
// Modifications:
//   
// ****************************************************************************

public class IsovolumeAttributes extends AttributeSubject implements Plugin
{
    public IsovolumeAttributes()
    {
        super(3);

        lbound = -1e+37;
        ubound = 1e+37;
        variable = new String("default");
    }

    public IsovolumeAttributes(IsovolumeAttributes obj)
    {
        super(3);

        lbound = obj.lbound;
        ubound = obj.ubound;
        variable = new String(obj.variable);

        SelectAll();
    }

    public boolean equals(IsovolumeAttributes obj)
    {
        // Create the return value
        return ((lbound == obj.lbound) &&
                (ubound == obj.ubound) &&
                (variable == obj.variable));
    }

    public String GetName() { return "Isovolume"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetLbound(double lbound_)
    {
        lbound = lbound_;
        Select(0);
    }

    public void SetUbound(double ubound_)
    {
        ubound = ubound_;
        Select(1);
    }

    public void SetVariable(String variable_)
    {
        variable = variable_;
        Select(2);
    }

    // Property getting methods
    public double GetLbound() { return lbound; }
    public double GetUbound() { return ubound; }
    public String GetVariable() { return variable; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteDouble(lbound);
        if(WriteSelect(1, buf))
            buf.WriteDouble(ubound);
        if(WriteSelect(2, buf))
            buf.WriteString(variable);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetLbound(buf.ReadDouble());
                break;
            case 1:
                SetUbound(buf.ReadDouble());
                break;
            case 2:
                SetVariable(buf.ReadString());
                break;
            }
        }
    }


    // Attributes
    private double lbound;
    private double ubound;
    private String variable;
}

