// ************************************************************************* //
//  File: avtIsosurfaceFilter.C
// ************************************************************************* //

#include <avtIsosurfaceFilter.h>

#include <ContourOpAttributes.h>

#include <avtContourFilter.h>


// ****************************************************************************
//  Method: avtIsosurfaceFilter constructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Apr 16 10:37:31 PDT 2002
//
// ****************************************************************************

avtIsosurfaceFilter::avtIsosurfaceFilter()
{
    cf = NULL;
}


// ****************************************************************************
//  Method: avtIsosurfaceFilter destructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Apr 16 10:37:31 PDT 2002
//
//  Modifications:
//
// ****************************************************************************

avtIsosurfaceFilter::~avtIsosurfaceFilter()
{
    if (cf != NULL)
    {
        delete cf;
        cf = NULL;
    }
}


// ****************************************************************************
//  Method:  avtIsosurfaceFilter::Create
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Apr 16 10:37:31 PDT 2002
//
// ****************************************************************************

avtFilter *
avtIsosurfaceFilter::Create()
{
    return new avtIsosurfaceFilter();
}


// ****************************************************************************
//  Method:      avtIsosurfaceFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Apr 16 10:37:31 PDT 2002
//
// ****************************************************************************

void
avtIsosurfaceFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const IsosurfaceAttributes*)a;

    //
    // Construct a new contour filter based on these attributes.
    //
    if (cf != NULL)
    {
        delete cf;
    }
    ContourOpAttributes coa;
    coa.SetContourNLevels(atts.GetContourNLevels());
    coa.SetContourValue(atts.GetContourValue());
    coa.SetContourPercent(atts.GetContourPercent());
    coa.SetContourMethod(ContourOpAttributes::ContourMethod(
        atts.GetContourMethod()));
    coa.SetMinFlag(atts.GetMinFlag());
    coa.SetMaxFlag(atts.GetMaxFlag());
    coa.SetMin(atts.GetMin());
    coa.SetMax(atts.GetMax());
    coa.SetScaling(ContourOpAttributes::ContourScaling(atts.GetScaling()));
    coa.SetVariable(atts.GetVariable());
    cf = new avtContourFilter(coa);
    cf->ShouldCreateLabels(false);
}


// ****************************************************************************
//  Method: avtIsosurfaceFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtIsosurfaceFilter with the given
//      parameters would result in an equivalent avtIsosurfaceFilter.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Apr 16 10:37:31 PDT 2002
//
// ****************************************************************************

bool
avtIsosurfaceFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(IsosurfaceAttributes*)a);
}

// ****************************************************************************
//  Method: avtIsosurfaceFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Hank Childs
//  Creation:   April 16, 2002
//
// ****************************************************************************

avtFilter *
avtIsosurfaceFilter::GetFacadedFilter(void)
{
    return cf;
}

