#include <PyIsosurfaceAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyIsosurfaceAttributes
//
// Purpose: 
//   Attributes for the isosurface operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Mon Dec 16 10:11:45 PDT 2002
//
// ****************************************************************************

//
// This struct contains the Python type information and a IsosurfaceAttributes.
//
struct IsosurfaceAttributesObject
{
    PyObject_HEAD
    IsosurfaceAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewIsosurfaceAttributes();

static PyObject *
IsosurfaceAttributes_Notify(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IsosurfaceAttributes_SetContourNLevels(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the contourNLevels in the object.
    obj->data->SetContourNLevels(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IsosurfaceAttributes_GetContourNLevels(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetContourNLevels()));
    return retval;
}

static PyObject *
IsosurfaceAttributes_SetContourValue(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    doubleVector  &vec = obj->data->GetContourValue();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the contourValue in the object as modified.
    obj->data->SelectContourValue();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IsosurfaceAttributes_GetContourValue(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the contourValue.
    const doubleVector &contourValue = obj->data->GetContourValue();
    PyObject *retval = PyTuple_New(contourValue.size());
    for(int i = 0; i < contourValue.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(contourValue[i]));
    return retval;
}

static PyObject *
IsosurfaceAttributes_SetContourPercent(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    doubleVector  &vec = obj->data->GetContourPercent();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the contourPercent in the object as modified.
    obj->data->SelectContourPercent();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IsosurfaceAttributes_GetContourPercent(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the contourPercent.
    const doubleVector &contourPercent = obj->data->GetContourPercent();
    PyObject *retval = PyTuple_New(contourPercent.size());
    for(int i = 0; i < contourPercent.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(contourPercent[i]));
    return retval;
}

static PyObject *
IsosurfaceAttributes_SetContourMethod(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the contourMethod in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetContourMethod(IsosurfaceAttributes::Select_by(ival));
    else
    {
        fprintf(stderr, "An invalid contourMethod value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Level, Value, Percent.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IsosurfaceAttributes_GetContourMethod(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetContourMethod()));
    return retval;
}

static PyObject *
IsosurfaceAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IsosurfaceAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

static PyObject *
IsosurfaceAttributes_SetMin(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IsosurfaceAttributes_GetMin(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

static PyObject *
IsosurfaceAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IsosurfaceAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

static PyObject *
IsosurfaceAttributes_SetMax(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IsosurfaceAttributes_GetMax(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}

static PyObject *
IsosurfaceAttributes_SetScaling(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaling in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetScaling(IsosurfaceAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid scaling value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Linear, Log.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IsosurfaceAttributes_GetScaling(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScaling()));
    return retval;
}

static PyObject *
IsosurfaceAttributes_SetVariable(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the variable in the object.
    obj->data->SetVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IsosurfaceAttributes_GetVariable(PyObject *self, PyObject *args)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVariable().c_str());
    return retval;
}



static struct PyMethodDef IsosurfaceAttributes_methods[] = {
    {"Notify", IsosurfaceAttributes_Notify, METH_VARARGS},
    {"SetContourNLevels", IsosurfaceAttributes_SetContourNLevels, METH_VARARGS},
    {"GetContourNLevels", IsosurfaceAttributes_GetContourNLevels, METH_VARARGS},
    {"SetContourValue", IsosurfaceAttributes_SetContourValue, METH_VARARGS},
    {"GetContourValue", IsosurfaceAttributes_GetContourValue, METH_VARARGS},
    {"SetContourPercent", IsosurfaceAttributes_SetContourPercent, METH_VARARGS},
    {"GetContourPercent", IsosurfaceAttributes_GetContourPercent, METH_VARARGS},
    {"SetContourMethod", IsosurfaceAttributes_SetContourMethod, METH_VARARGS},
    {"GetContourMethod", IsosurfaceAttributes_GetContourMethod, METH_VARARGS},
    {"SetMinFlag", IsosurfaceAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", IsosurfaceAttributes_GetMinFlag, METH_VARARGS},
    {"SetMin", IsosurfaceAttributes_SetMin, METH_VARARGS},
    {"GetMin", IsosurfaceAttributes_GetMin, METH_VARARGS},
    {"SetMaxFlag", IsosurfaceAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", IsosurfaceAttributes_GetMaxFlag, METH_VARARGS},
    {"SetMax", IsosurfaceAttributes_SetMax, METH_VARARGS},
    {"GetMax", IsosurfaceAttributes_GetMax, METH_VARARGS},
    {"SetScaling", IsosurfaceAttributes_SetScaling, METH_VARARGS},
    {"GetScaling", IsosurfaceAttributes_GetScaling, METH_VARARGS},
    {"SetVariable", IsosurfaceAttributes_SetVariable, METH_VARARGS},
    {"GetVariable", IsosurfaceAttributes_GetVariable, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
IsosurfaceAttributes_dealloc(PyObject *v)
{
   IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
IsosurfaceAttributes_compare(PyObject *v, PyObject *w)
{
    IsosurfaceAttributes *a = ((IsosurfaceAttributesObject *)v)->data;
    IsosurfaceAttributes *b = ((IsosurfaceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
IsosurfaceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "contourNLevels") == 0)
        return IsosurfaceAttributes_GetContourNLevels(self, NULL);
    if(strcmp(name, "contourValue") == 0)
        return IsosurfaceAttributes_GetContourValue(self, NULL);
    if(strcmp(name, "contourPercent") == 0)
        return IsosurfaceAttributes_GetContourPercent(self, NULL);
    if(strcmp(name, "contourMethod") == 0)
        return IsosurfaceAttributes_GetContourMethod(self, NULL);
    if(strcmp(name, "Level") == 0)
        return PyInt_FromLong(long(IsosurfaceAttributes::Level));
    else if(strcmp(name, "Value") == 0)
        return PyInt_FromLong(long(IsosurfaceAttributes::Value));
    else if(strcmp(name, "Percent") == 0)
        return PyInt_FromLong(long(IsosurfaceAttributes::Percent));

    if(strcmp(name, "minFlag") == 0)
        return IsosurfaceAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "min") == 0)
        return IsosurfaceAttributes_GetMin(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return IsosurfaceAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "max") == 0)
        return IsosurfaceAttributes_GetMax(self, NULL);
    if(strcmp(name, "scaling") == 0)
        return IsosurfaceAttributes_GetScaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(IsosurfaceAttributes::Linear));
    else if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(IsosurfaceAttributes::Log));

    if(strcmp(name, "variable") == 0)
        return IsosurfaceAttributes_GetVariable(self, NULL);

    return Py_FindMethod(IsosurfaceAttributes_methods, self, name);
}

static int
IsosurfaceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "contourNLevels") == 0)
        retval = (IsosurfaceAttributes_SetContourNLevels(self, tuple) != NULL);
    else if(strcmp(name, "contourValue") == 0)
        retval = (IsosurfaceAttributes_SetContourValue(self, tuple) != NULL);
    else if(strcmp(name, "contourPercent") == 0)
        retval = (IsosurfaceAttributes_SetContourPercent(self, tuple) != NULL);
    else if(strcmp(name, "contourMethod") == 0)
        retval = (IsosurfaceAttributes_SetContourMethod(self, tuple) != NULL);
    else if(strcmp(name, "minFlag") == 0)
        retval = (IsosurfaceAttributes_SetMinFlag(self, tuple) != NULL);
    else if(strcmp(name, "min") == 0)
        retval = (IsosurfaceAttributes_SetMin(self, tuple) != NULL);
    else if(strcmp(name, "maxFlag") == 0)
        retval = (IsosurfaceAttributes_SetMaxFlag(self, tuple) != NULL);
    else if(strcmp(name, "max") == 0)
        retval = (IsosurfaceAttributes_SetMax(self, tuple) != NULL);
    else if(strcmp(name, "scaling") == 0)
        retval = (IsosurfaceAttributes_SetScaling(self, tuple) != NULL);
    else if(strcmp(name, "variable") == 0)
        retval = (IsosurfaceAttributes_SetVariable(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
IsosurfaceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    IsosurfaceAttributesObject *obj = (IsosurfaceAttributesObject *)v;

    fprintf(fp, "contourNLevels = %d\n", obj->data->GetContourNLevels());
    {   const doubleVector &contourValue = obj->data->GetContourValue();
        fprintf(fp, "contourValue = (");
        for(int i = 0; i < contourValue.size(); ++i)
        {
            fprintf(fp, "%g", contourValue[i]);
            if(i < contourValue.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const doubleVector &contourPercent = obj->data->GetContourPercent();
        fprintf(fp, "contourPercent = (");
        for(int i = 0; i < contourPercent.size(); ++i)
        {
            fprintf(fp, "%g", contourPercent[i]);
            if(i < contourPercent.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    const char *contourMethod_names = "Level, Value, Percent";
    if(obj->data->GetContourMethod() == IsosurfaceAttributes::Level)
        fprintf(fp, "contourMethod = Level  # %s\n", contourMethod_names);
    else if(obj->data->GetContourMethod() == IsosurfaceAttributes::Value)
        fprintf(fp, "contourMethod = Value  # %s\n", contourMethod_names);
    else
        fprintf(fp, "contourMethod = Percent  # %s\n", contourMethod_names);

    if(obj->data->GetMinFlag())
        fprintf(fp, "minFlag = 1\n");
    else
        fprintf(fp, "minFlag = 0\n");
    fprintf(fp, "min = %g\n", obj->data->GetMin());
    if(obj->data->GetMaxFlag())
        fprintf(fp, "maxFlag = 1\n");
    else
        fprintf(fp, "maxFlag = 0\n");
    fprintf(fp, "max = %g\n", obj->data->GetMax());
    const char *scaling_names = "Linear, Log";
    if(obj->data->GetScaling() == IsosurfaceAttributes::Linear)
        fprintf(fp, "scaling = Linear  # %s\n", scaling_names);
    else
        fprintf(fp, "scaling = Log  # %s\n", scaling_names);

    fprintf(fp, "variable = \"%s\"\n", obj->data->GetVariable().c_str());

    return 0;
}

//
// The doc string for the class.
//
static char *IsosurfaceAttributes_Purpose = "Attributes for the isosurface operator";

//
// The type description structure
//
static PyTypeObject IsosurfaceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "IsosurfaceAttributes",                    // tp_name
    sizeof(IsosurfaceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)IsosurfaceAttributes_dealloc,  // tp_dealloc
    (printfunc)IsosurfaceAttributes_print,     // tp_print
    (getattrfunc)IsosurfaceAttributes_getattr, // tp_getattr
    (setattrfunc)IsosurfaceAttributes_setattr, // tp_setattr
    (cmpfunc)IsosurfaceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    IsosurfaceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static IsosurfaceAttributes *defaultAtts = 0;

static PyObject *
NewIsosurfaceAttributes()
{
    IsosurfaceAttributesObject *newObject;
    newObject = PyObject_NEW(IsosurfaceAttributesObject, &IsosurfaceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new IsosurfaceAttributes(*defaultAtts);
    else
        newObject->data = new IsosurfaceAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapIsosurfaceAttributes(const IsosurfaceAttributes *attr)
{
    IsosurfaceAttributesObject *newObject;
    newObject = PyObject_NEW(IsosurfaceAttributesObject, &IsosurfaceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (IsosurfaceAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
IsosurfaceAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewIsosurfaceAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef IsosurfaceAttributesMethods[] = {
    {"IsosurfaceAttributes", IsosurfaceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *IsosurfaceAttributesObserver = 0;
static bool IsosurfaceAttributesEnableLogging = true;

static void
PyIsosurfaceAttributes_WriteLog(Subject *subj, void *data)
{
    IsosurfaceAttributes *atts = (IsosurfaceAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!IsosurfaceAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# IsosurfaceAttributes_WriteLog()\n");
}

void
PyIsosurfaceAttributes_StartUp(IsosurfaceAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyIsosurfaceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(IsosurfaceAttributesObserver == 0)
    {
        IsosurfaceAttributesObserver = new ObserverToCallback(subj,
            PyIsosurfaceAttributes_WriteLog, (void *)logFile);
    }

    IsosurfaceAttributesEnableLogging = true;
}

void
PyIsosurfaceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete IsosurfaceAttributesObserver;
    IsosurfaceAttributesObserver = 0;
}

PyMethodDef *
PyIsosurfaceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return IsosurfaceAttributesMethods;
}

bool
PyIsosurfaceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &IsosurfaceAttributesType);
}

IsosurfaceAttributes *
PyIsosurfaceAttributes_FromPyObject(PyObject *obj)
{
    IsosurfaceAttributesObject *obj2 = (IsosurfaceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyIsosurfaceAttributes_NewPyObject()
{
    return NewIsosurfaceAttributes();
}

PyObject *
PyIsosurfaceAttributes_WrapPyObject(const IsosurfaceAttributes *attr)
{
    return WrapIsosurfaceAttributes(attr);
}

void
PyIsosurfaceAttributes_SetLogging(bool val)
{
    IsosurfaceAttributesEnableLogging = val;
}

void
PyIsosurfaceAttributes_SetDefaults(const IsosurfaceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new IsosurfaceAttributes(*atts);
}

