// ************************************************************************* //
//  File: IsosurfaceViewerPluginInfo.C
// ************************************************************************* //

#include <IsosurfacePluginInfo.h>
#include <IsosurfaceAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Isosurface_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Isosurface operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:23 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    IsosurfaceViewerPluginInfo::InitializeGlobalObjects();
    return new IsosurfaceViewerPluginInfo;
}

//
// Storage for static data elements.
//
IsosurfaceAttributes *IsosurfaceViewerPluginInfo::clientAtts = NULL;
IsosurfaceAttributes *IsosurfaceViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  IsosurfaceViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:23 PST 2003
//
// ****************************************************************************
void
IsosurfaceViewerPluginInfo::InitializeGlobalObjects()
{
    IsosurfaceViewerPluginInfo::clientAtts  = new IsosurfaceAttributes;
    IsosurfaceViewerPluginInfo::defaultAtts = new IsosurfaceAttributes;
}

// ****************************************************************************
//  Method: IsosurfaceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:23 PST 2003
//
// ****************************************************************************

AttributeSubject *
IsosurfaceViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: IsosurfaceViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:23 PST 2003
//
// ****************************************************************************

AttributeSubject *
IsosurfaceViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: IsosurfaceViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:23 PST 2003
//
// ****************************************************************************

void
IsosurfaceViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(IsosurfaceAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: IsosurfaceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:23 PST 2003
//
// ****************************************************************************

void
IsosurfaceViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(IsosurfaceAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: IsosurfaceViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:23 PST 2003
//
// ****************************************************************************

void
IsosurfaceViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(IsosurfaceAttributes*)atts = *defaultAtts;
    else
        *(IsosurfaceAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: IsosurfaceViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:03:23 PST 2003
//
// ****************************************************************************

#include <Isosurface.xpm>
const char **
IsosurfaceViewerPluginInfo::XPMIconData() const
{
    return Isosurface_xpm;
}
