// ************************************************************************* //
//  File: IsosurfaceGUIPluginInfo.C
// ************************************************************************* //

#include <IsosurfacePluginInfo.h>
#include <IsosurfaceAttributes.h>
#include <QvisIsosurfaceWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Isosurface_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Isosurface operator.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 16:32:53 PST 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new IsosurfaceGUIPluginInfo;
}

// ****************************************************************************
//  Method: IsosurfaceGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 16:32:53 PST 2003
//
// ****************************************************************************

const char *
IsosurfaceGUIPluginInfo::GetMenuName() const
{
    return "Isosurface";
}


// ****************************************************************************
//  Method: IsosurfaceGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 16:32:53 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
IsosurfaceGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisIsosurfaceWindow(type, (IsosurfaceAttributes *)attr,
        "Isosurface operator attributes", "Isosurface operator", notepad);
}

// ****************************************************************************
//  Method: IsosurfaceGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 16:32:53 PST 2003
//
// ****************************************************************************

#include <Isosurface.xpm>
const char **
IsosurfaceGUIPluginInfo::XPMIconData() const
{
    return Isosurface_xpm;
}
