#ifndef ISOSURFACEATTRIBUTES_H
#define ISOSURFACEATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: IsosurfaceAttributes
//
// Purpose:
//    Attributes for the isosurface operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

class IsosurfaceAttributes : public AttributeSubject
{
public:
    enum Select_by
    {
        Level,
        Value,
        Percent
    };
    enum Scaling
    {
        Linear,
        Log
    };

    IsosurfaceAttributes();
    IsosurfaceAttributes(const IsosurfaceAttributes &obj);
    virtual ~IsosurfaceAttributes();

    virtual void operator = (const IsosurfaceAttributes &obj);
    virtual bool operator == (const IsosurfaceAttributes &obj) const;
    virtual bool operator != (const IsosurfaceAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectContourValue();
    void SelectContourPercent();
    void SelectVariable();

    // Property setting methods
    void SetContourNLevels(int contourNLevels_);
    void SetContourValue(const doubleVector &contourValue_);
    void SetContourPercent(const doubleVector &contourPercent_);
    void SetContourMethod(Select_by contourMethod_);
    void SetMinFlag(bool minFlag_);
    void SetMin(double min_);
    void SetMaxFlag(bool maxFlag_);
    void SetMax(double max_);
    void SetScaling(Scaling scaling_);
    void SetVariable(const std::string &variable_);

    // Property getting methods
    int                GetContourNLevels() const;
    const doubleVector &GetContourValue() const;
          doubleVector &GetContourValue();
    const doubleVector &GetContourPercent() const;
          doubleVector &GetContourPercent();
    Select_by          GetContourMethod() const;
    bool               GetMinFlag() const;
    double             GetMin() const;
    bool               GetMaxFlag() const;
    double             GetMax() const;
    Scaling            GetScaling() const;
    const std::string  &GetVariable() const;
          std::string  &GetVariable();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string Select_by_ToString(Select_by);
    static bool Select_by_FromString(const std::string &, Select_by &);
protected:
    static std::string Select_by_ToString(int);
public:
    static std::string Scaling_ToString(Scaling);
    static bool Scaling_FromString(const std::string &, Scaling &);
protected:
    static std::string Scaling_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    int          contourNLevels;
    doubleVector contourValue;
    doubleVector contourPercent;
    int          contourMethod;
    bool         minFlag;
    double       min;
    bool         maxFlag;
    double       max;
    int          scaling;
    std::string  variable;
};

#endif
