#include <IsosurfaceAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for IsosurfaceAttributes::Select_by
//

static const char *Select_by_strings[] = {
"Level", "Value", "Percent"
};

std::string
IsosurfaceAttributes::Select_by_ToString(IsosurfaceAttributes::Select_by t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Select_by_strings[index];
}

std::string
IsosurfaceAttributes::Select_by_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Select_by_strings[index];
}

bool
IsosurfaceAttributes::Select_by_FromString(const std::string &s, IsosurfaceAttributes::Select_by &val)
{
    val = IsosurfaceAttributes::Level;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Select_by_strings[i])
        {
            val = (Select_by)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for IsosurfaceAttributes::Scaling
//

static const char *Scaling_strings[] = {
"Linear", "Log"};

std::string
IsosurfaceAttributes::Scaling_ToString(IsosurfaceAttributes::Scaling t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return Scaling_strings[index];
}

std::string
IsosurfaceAttributes::Scaling_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return Scaling_strings[index];
}

bool
IsosurfaceAttributes::Scaling_FromString(const std::string &s, IsosurfaceAttributes::Scaling &val)
{
    val = IsosurfaceAttributes::Linear;
    for(int i = 0; i < 2; ++i)
    {
        if(s == Scaling_strings[i])
        {
            val = (Scaling)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: IsosurfaceAttributes::IsosurfaceAttributes
//
// Purpose: 
//   Constructor for the IsosurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

IsosurfaceAttributes::IsosurfaceAttributes() : AttributeSubject("id*d*ibdbdis")
{
    contourNLevels = 10;
    contourMethod = Level;
    minFlag = false;
    min = 0;
    maxFlag = false;
    max = 1;
    scaling = Linear;
    variable = "default";
}

// ****************************************************************************
// Method: IsosurfaceAttributes::IsosurfaceAttributes
//
// Purpose: 
//   Copy constructor for the IsosurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

IsosurfaceAttributes::IsosurfaceAttributes(const IsosurfaceAttributes &obj) : AttributeSubject("id*d*ibdbdis")
{
    contourNLevels = obj.contourNLevels;
    contourValue = obj.contourValue;
    contourPercent = obj.contourPercent;
    contourMethod = obj.contourMethod;
    minFlag = obj.minFlag;
    min = obj.min;
    maxFlag = obj.maxFlag;
    max = obj.max;
    scaling = obj.scaling;
    variable = obj.variable;

    SelectAll();
}

// ****************************************************************************
// Method: IsosurfaceAttributes::~IsosurfaceAttributes
//
// Purpose: 
//   Destructor for the IsosurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

IsosurfaceAttributes::~IsosurfaceAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: IsosurfaceAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the IsosurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
IsosurfaceAttributes::operator = (const IsosurfaceAttributes &obj)
{
    contourNLevels = obj.contourNLevels;
    contourValue = obj.contourValue;
    contourPercent = obj.contourPercent;
    contourMethod = obj.contourMethod;
    minFlag = obj.minFlag;
    min = obj.min;
    maxFlag = obj.maxFlag;
    max = obj.max;
    scaling = obj.scaling;
    variable = obj.variable;

    SelectAll();
}

// ****************************************************************************
// Method: IsosurfaceAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the IsosurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
IsosurfaceAttributes::operator == (const IsosurfaceAttributes &obj) const
{
    // Create the return value
    return ((contourNLevels == obj.contourNLevels) &&
            (contourValue == obj.contourValue) &&
            (contourPercent == obj.contourPercent) &&
            (contourMethod == obj.contourMethod) &&
            (minFlag == obj.minFlag) &&
            (min == obj.min) &&
            (maxFlag == obj.maxFlag) &&
            (max == obj.max) &&
            (scaling == obj.scaling) &&
            (variable == obj.variable));
}

// ****************************************************************************
// Method: IsosurfaceAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the IsosurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
IsosurfaceAttributes::operator != (const IsosurfaceAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: IsosurfaceAttributes::TypeName
//
// Purpose: 
//   Type name method for the IsosurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
IsosurfaceAttributes::TypeName() const
{
    return "IsosurfaceAttributes";
}

// ****************************************************************************
// Method: IsosurfaceAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the IsosurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
IsosurfaceAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const IsosurfaceAttributes *tmp = (const IsosurfaceAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: IsosurfaceAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the IsosurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
IsosurfaceAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new IsosurfaceAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: IsosurfaceAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the IsosurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
IsosurfaceAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new IsosurfaceAttributes(*this);
    else
        retval = new IsosurfaceAttributes;

    return retval;
}

// ****************************************************************************
// Method: IsosurfaceAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
IsosurfaceAttributes::SelectAll()
{
    Select(0, (void *)&contourNLevels);
    Select(1, (void *)&contourValue);
    Select(2, (void *)&contourPercent);
    Select(3, (void *)&contourMethod);
    Select(4, (void *)&minFlag);
    Select(5, (void *)&min);
    Select(6, (void *)&maxFlag);
    Select(7, (void *)&max);
    Select(8, (void *)&scaling);
    Select(9, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: IsosurfaceAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
IsosurfaceAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    IsosurfaceAttributes defaultObject;
    bool addToParent = false;
    // Create a node for IsosurfaceAttributes.
    DataNode *node = new DataNode("IsosurfaceAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("contourNLevels", contourNLevels));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("contourValue", contourValue));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("contourPercent", contourPercent));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("contourMethod", Select_by_ToString(contourMethod)));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minFlag", minFlag));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("min", min));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxFlag", maxFlag));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("max", max));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaling", Scaling_ToString(scaling)));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("variable", variable));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: IsosurfaceAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
IsosurfaceAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("IsosurfaceAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("contourNLevels")) != 0)
        SetContourNLevels(node->AsInt());
    if((node = searchNode->GetNode("contourValue")) != 0)
        SetContourValue(node->AsDoubleVector());
    if((node = searchNode->GetNode("contourPercent")) != 0)
        SetContourPercent(node->AsDoubleVector());
    if((node = searchNode->GetNode("contourMethod")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetContourMethod(Select_by(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Select_by value;
            if(Select_by_FromString(node->AsString(), value))
                SetContourMethod(value);
        }
    }
    if((node = searchNode->GetNode("minFlag")) != 0)
        SetMinFlag(node->AsBool());
    if((node = searchNode->GetNode("min")) != 0)
        SetMin(node->AsDouble());
    if((node = searchNode->GetNode("maxFlag")) != 0)
        SetMaxFlag(node->AsBool());
    if((node = searchNode->GetNode("max")) != 0)
        SetMax(node->AsDouble());
    if((node = searchNode->GetNode("scaling")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetScaling(Scaling(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Scaling value;
            if(Scaling_FromString(node->AsString(), value))
                SetScaling(value);
        }
    }
    if((node = searchNode->GetNode("variable")) != 0)
        SetVariable(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
IsosurfaceAttributes::SetContourNLevels(int contourNLevels_)
{
    contourNLevels = contourNLevels_;
    Select(0, (void *)&contourNLevels);
}

void
IsosurfaceAttributes::SetContourValue(const doubleVector &contourValue_)
{
    contourValue = contourValue_;
    Select(1, (void *)&contourValue);
}

void
IsosurfaceAttributes::SetContourPercent(const doubleVector &contourPercent_)
{
    contourPercent = contourPercent_;
    Select(2, (void *)&contourPercent);
}

void
IsosurfaceAttributes::SetContourMethod(IsosurfaceAttributes::Select_by contourMethod_)
{
    contourMethod = contourMethod_;
    Select(3, (void *)&contourMethod);
}

void
IsosurfaceAttributes::SetMinFlag(bool minFlag_)
{
    minFlag = minFlag_;
    Select(4, (void *)&minFlag);
}

void
IsosurfaceAttributes::SetMin(double min_)
{
    min = min_;
    Select(5, (void *)&min);
}

void
IsosurfaceAttributes::SetMaxFlag(bool maxFlag_)
{
    maxFlag = maxFlag_;
    Select(6, (void *)&maxFlag);
}

void
IsosurfaceAttributes::SetMax(double max_)
{
    max = max_;
    Select(7, (void *)&max);
}

void
IsosurfaceAttributes::SetScaling(IsosurfaceAttributes::Scaling scaling_)
{
    scaling = scaling_;
    Select(8, (void *)&scaling);
}

void
IsosurfaceAttributes::SetVariable(const std::string &variable_)
{
    variable = variable_;
    Select(9, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
IsosurfaceAttributes::GetContourNLevels() const
{
    return contourNLevels;
}

const doubleVector &
IsosurfaceAttributes::GetContourValue() const
{
    return contourValue;
}

doubleVector &
IsosurfaceAttributes::GetContourValue()
{
    return contourValue;
}

const doubleVector &
IsosurfaceAttributes::GetContourPercent() const
{
    return contourPercent;
}

doubleVector &
IsosurfaceAttributes::GetContourPercent()
{
    return contourPercent;
}

IsosurfaceAttributes::Select_by
IsosurfaceAttributes::GetContourMethod() const
{
    return Select_by(contourMethod);
}

bool
IsosurfaceAttributes::GetMinFlag() const
{
    return minFlag;
}

double
IsosurfaceAttributes::GetMin() const
{
    return min;
}

bool
IsosurfaceAttributes::GetMaxFlag() const
{
    return maxFlag;
}

double
IsosurfaceAttributes::GetMax() const
{
    return max;
}

IsosurfaceAttributes::Scaling
IsosurfaceAttributes::GetScaling() const
{
    return Scaling(scaling);
}

const std::string &
IsosurfaceAttributes::GetVariable() const
{
    return variable;
}

std::string &
IsosurfaceAttributes::GetVariable()
{
    return variable;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
IsosurfaceAttributes::SelectContourValue()
{
    Select(1, (void *)&contourValue);
}

void
IsosurfaceAttributes::SelectContourPercent()
{
    Select(2, (void *)&contourPercent);
}

void
IsosurfaceAttributes::SelectVariable()
{
    Select(9, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: IsosurfaceAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
IsosurfaceAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "contourNLevels";
        case 1:  return "contourValue";
        case 2:  return "contourPercent";
        case 3:  return "contourMethod";
        case 4:  return "minFlag";
        case 5:  return "min";
        case 6:  return "maxFlag";
        case 7:  return "max";
        case 8:  return "scaling";
        case 9:  return "variable";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: IsosurfaceAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
IsosurfaceAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_int;
        case 1:  return FieldType_doubleVector;
        case 2:  return FieldType_doubleVector;
        case 3:  return FieldType_enum;
        case 4:  return FieldType_bool;
        case 5:  return FieldType_double;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_double;
        case 8:  return FieldType_enum;
        case 9:  return FieldType_variablename;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: IsosurfaceAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
IsosurfaceAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "int";
        case 1:  return "doubleVector";
        case 2:  return "doubleVector";
        case 3:  return "enum";
        case 4:  return "bool";
        case 5:  return "double";
        case 6:  return "bool";
        case 7:  return "double";
        case 8:  return "enum";
        case 9:  return "variablename";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: IsosurfaceAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:50 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
IsosurfaceAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const IsosurfaceAttributes &obj = *((const IsosurfaceAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (contourNLevels == obj.contourNLevels);
        }
        break;
    case 1:
        {  // new scope
        retval = (contourValue == obj.contourValue);
        }
        break;
    case 2:
        {  // new scope
        retval = (contourPercent == obj.contourPercent);
        }
        break;
    case 3:
        {  // new scope
        retval = (contourMethod == obj.contourMethod);
        }
        break;
    case 4:
        {  // new scope
        retval = (minFlag == obj.minFlag);
        }
        break;
    case 5:
        {  // new scope
        retval = (min == obj.min);
        }
        break;
    case 6:
        {  // new scope
        retval = (maxFlag == obj.maxFlag);
        }
        break;
    case 7:
        {  // new scope
        retval = (max == obj.max);
        }
        break;
    case 8:
        {  // new scope
        retval = (scaling == obj.scaling);
        }
        break;
    case 9:
        {  // new scope
        retval = (variable == obj.variable);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

