// ************************************************************************* //
//  File: avtInverseGhostZoneFilter.C
// ************************************************************************* //

#include <avtInverseGhostZoneFilter.h>

#include <vtkCellData.h>
#include <vtkDataSet.h>
#include <vtkUnsignedCharArray.h>


// ****************************************************************************
//  Method: avtInverseGhostZoneFilter constructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:27:11 PDT 2004
//
// ****************************************************************************

avtInverseGhostZoneFilter::avtInverseGhostZoneFilter()
{
}


// ****************************************************************************
//  Method: avtInverseGhostZoneFilter destructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:27:11 PDT 2004
//
//  Modifications:
//
// ****************************************************************************

avtInverseGhostZoneFilter::~avtInverseGhostZoneFilter()
{
}


// ****************************************************************************
//  Method:  avtInverseGhostZoneFilter::Create
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:27:11 PDT 2004
//
// ****************************************************************************

avtFilter *
avtInverseGhostZoneFilter::Create()
{
    return new avtInverseGhostZoneFilter();
}


// ****************************************************************************
//  Method:      avtInverseGhostZoneFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:27:11 PDT 2004
//
// ****************************************************************************

void
avtInverseGhostZoneFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const InverseGhostZoneAttributes*)a;
}


// ****************************************************************************
//  Method: avtInverseGhostZoneFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtInverseGhostZoneFilter with the given
//      parameters would result in an equivalent avtInverseGhostZoneFilter.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:27:11 PDT 2004
//
// ****************************************************************************

bool
avtInverseGhostZoneFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(InverseGhostZoneAttributes*)a);
}


// ****************************************************************************
//  Method: avtInverseGhostZoneFilter::ExecuteData
//
//  Purpose:
//      Sends the specified input and output through the InverseGhostZone filter.
//
//  Arguments:
//      in_ds      The input dataset.
//      <unused>   The domain number.
//      <unused>   The label.
//
//  Returns:       The output dataset.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:27:11 PDT 2004
//
//  Modifications:
//
//    Hank Childs, Fri Aug 27 15:25:22 PDT 2004
//    Rename ghost data array.
//
// ****************************************************************************

vtkDataSet *
avtInverseGhostZoneFilter::ExecuteData(vtkDataSet *in_ds, int, std::string)
{
    vtkDataArray *gz = in_ds->GetCellData()->GetArray("avtGhostZones");
    if (gz == NULL)
    {
        return in_ds;
    }

    //
    // Make an output that is identical to the input.
    //
    vtkDataSet *out_ds = (vtkDataSet *) in_ds->NewInstance();
    out_ds->ShallowCopy(in_ds);

    if (atts.GetShowType() == InverseGhostZoneAttributes::GhostZonesOnly)
    {
        int nCells = in_ds->GetNumberOfCells();
        unsigned char *gza = ((vtkUnsignedCharArray*)gz)->GetPointer(0);
        vtkUnsignedCharArray *ghostZones = vtkUnsignedCharArray::New();
        ghostZones->SetName("avtGhostZones");
        ghostZones->Allocate(nCells);
        for (int i = 0 ; i < nCells ; i++)
        {
            unsigned char ghost = (gza[i] == 0 ? 1 : 0);
            ghostZones->InsertNextValue(ghost);
        }
        out_ds->GetCellData()->RemoveArray("avtGhostZones");
        out_ds->GetCellData()->AddArray(ghostZones);
    }
    else
    {
        out_ds->GetCellData()->RemoveArray("avtGhostZones");
    }

    ManageMemory(out_ds);
    out_ds->Delete();
    return out_ds;
}


// ****************************************************************************
//  Method: avtInverseGhostZoneFilter::RefashionDataObjectInfo
//
//  Purpose:
//      Indicates the zones no longer correspond to the original problem.
//      (They of course do, but information about the zones, like facelists,
//       no longer apply).
//
//  Programmer: Hank Childs
//  Creation:   January 8, 2004
//
// ****************************************************************************

void
avtInverseGhostZoneFilter::RefashionDataObjectInfo(void)
{
    GetOutput()->GetInfo().GetValidity().InvalidateZones();
}


