#include <PyInverseGhostZoneAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyInverseGhostZoneAttributes
//
// Purpose: 
//   This class contains attributes for the inverse ghost zone operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu Jan 8 09:57:13 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a InverseGhostZoneAttributes.
//
struct InverseGhostZoneAttributesObject
{
    PyObject_HEAD
    InverseGhostZoneAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewInverseGhostZoneAttributes();

static PyObject *
InverseGhostZoneAttributes_Notify(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
InverseGhostZoneAttributes_SetShowType(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetShowType(InverseGhostZoneAttributes::ShowType(ival));
    else
    {
        fprintf(stderr, "An invalid showType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "GhostZonesOnly, GhostZonesAndRealZones.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
InverseGhostZoneAttributes_GetShowType(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetShowType()));
    return retval;
}



static struct PyMethodDef InverseGhostZoneAttributes_methods[] = {
    {"Notify", InverseGhostZoneAttributes_Notify, METH_VARARGS},
    {"SetShowType", InverseGhostZoneAttributes_SetShowType, METH_VARARGS},
    {"GetShowType", InverseGhostZoneAttributes_GetShowType, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
InverseGhostZoneAttributes_dealloc(PyObject *v)
{
   InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
InverseGhostZoneAttributes_compare(PyObject *v, PyObject *w)
{
    InverseGhostZoneAttributes *a = ((InverseGhostZoneAttributesObject *)v)->data;
    InverseGhostZoneAttributes *b = ((InverseGhostZoneAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
InverseGhostZoneAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "showType") == 0)
        return InverseGhostZoneAttributes_GetShowType(self, NULL);
    if(strcmp(name, "GhostZonesOnly") == 0)
        return PyInt_FromLong(long(InverseGhostZoneAttributes::GhostZonesOnly));
    else if(strcmp(name, "GhostZonesAndRealZones") == 0)
        return PyInt_FromLong(long(InverseGhostZoneAttributes::GhostZonesAndRealZones));


    return Py_FindMethod(InverseGhostZoneAttributes_methods, self, name);
}

static int
InverseGhostZoneAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "showType") == 0)
        retval = (InverseGhostZoneAttributes_SetShowType(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
InverseGhostZoneAttributes_print(PyObject *v, FILE *fp, int flags)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)v;

    const char *showType_names = "GhostZonesOnly, GhostZonesAndRealZones";
    if(obj->data->GetShowType() == InverseGhostZoneAttributes::GhostZonesOnly)
        fprintf(fp, "showType = GhostZonesOnly  # %s\n", showType_names);
    else
        fprintf(fp, "showType = GhostZonesAndRealZones  # %s\n", showType_names);


    return 0;
}

//
// The doc string for the class.
//
static char *InverseGhostZoneAttributes_Purpose = "This class contains attributes for the inverse ghost zone operator.";

//
// The type description structure
//
static PyTypeObject InverseGhostZoneAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "InverseGhostZoneAttributes",                    // tp_name
    sizeof(InverseGhostZoneAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)InverseGhostZoneAttributes_dealloc,  // tp_dealloc
    (printfunc)InverseGhostZoneAttributes_print,     // tp_print
    (getattrfunc)InverseGhostZoneAttributes_getattr, // tp_getattr
    (setattrfunc)InverseGhostZoneAttributes_setattr, // tp_setattr
    (cmpfunc)InverseGhostZoneAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    InverseGhostZoneAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static InverseGhostZoneAttributes *defaultAtts = 0;

static PyObject *
NewInverseGhostZoneAttributes()
{
    InverseGhostZoneAttributesObject *newObject;
    newObject = PyObject_NEW(InverseGhostZoneAttributesObject, &InverseGhostZoneAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new InverseGhostZoneAttributes(*defaultAtts);
    else
        newObject->data = new InverseGhostZoneAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapInverseGhostZoneAttributes(const InverseGhostZoneAttributes *attr)
{
    InverseGhostZoneAttributesObject *newObject;
    newObject = PyObject_NEW(InverseGhostZoneAttributesObject, &InverseGhostZoneAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (InverseGhostZoneAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
InverseGhostZoneAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewInverseGhostZoneAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef InverseGhostZoneAttributesMethods[] = {
    {"InverseGhostZoneAttributes", InverseGhostZoneAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *InverseGhostZoneAttributesObserver = 0;
static bool InverseGhostZoneAttributesEnableLogging = true;

static void
PyInverseGhostZoneAttributes_WriteLog(Subject *subj, void *data)
{
    InverseGhostZoneAttributes *atts = (InverseGhostZoneAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!InverseGhostZoneAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# InverseGhostZoneAttributes_WriteLog()\n");
}

void
PyInverseGhostZoneAttributes_StartUp(InverseGhostZoneAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyInverseGhostZoneAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(InverseGhostZoneAttributesObserver == 0)
    {
        InverseGhostZoneAttributesObserver = new ObserverToCallback(subj,
            PyInverseGhostZoneAttributes_WriteLog, (void *)logFile);
    }

    InverseGhostZoneAttributesEnableLogging = true;
}

void
PyInverseGhostZoneAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete InverseGhostZoneAttributesObserver;
    InverseGhostZoneAttributesObserver = 0;
}

PyMethodDef *
PyInverseGhostZoneAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return InverseGhostZoneAttributesMethods;
}

bool
PyInverseGhostZoneAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &InverseGhostZoneAttributesType);
}

InverseGhostZoneAttributes *
PyInverseGhostZoneAttributes_FromPyObject(PyObject *obj)
{
    InverseGhostZoneAttributesObject *obj2 = (InverseGhostZoneAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyInverseGhostZoneAttributes_NewPyObject()
{
    return NewInverseGhostZoneAttributes();
}

PyObject *
PyInverseGhostZoneAttributes_WrapPyObject(const InverseGhostZoneAttributes *attr)
{
    return WrapInverseGhostZoneAttributes(attr);
}

void
PyInverseGhostZoneAttributes_SetLogging(bool val)
{
    InverseGhostZoneAttributesEnableLogging = val;
}

void
PyInverseGhostZoneAttributes_SetDefaults(const InverseGhostZoneAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new InverseGhostZoneAttributes(*atts);
}

