// ************************************************************************* //
//  File: InverseGhostZoneGUIPluginInfo.C
// ************************************************************************* //

#include <InverseGhostZonePluginInfo.h>
#include <InverseGhostZoneAttributes.h>
#include <QvisInverseGhostZoneWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo InverseGhostZone_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the InverseGhostZone operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new InverseGhostZoneGUIPluginInfo;
}

// ****************************************************************************
//  Method: InverseGhostZoneGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// ****************************************************************************

const char *
InverseGhostZoneGUIPluginInfo::GetMenuName() const
{
    return "Inverse Ghost Zone";
}


// ****************************************************************************
//  Method: InverseGhostZoneGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// ****************************************************************************

QvisPostableWindowObserver *
InverseGhostZoneGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisInverseGhostZoneWindow(type, (InverseGhostZoneAttributes *)attr,
        "Inverse Ghost Zone operator attributes", "InverseGhostZone operator", notepad);
}

// ****************************************************************************
//  Method: InverseGhostZoneGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// ****************************************************************************

#include <InverseGhostZone.xpm>
const char **
InverseGhostZoneGUIPluginInfo::XPMIconData() const
{
    return InverseGhostZone_xpm;
}
