#include <InverseGhostZoneAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for InverseGhostZoneAttributes::ShowType
//

static const char *ShowType_strings[] = {
"GhostZonesOnly", "GhostZonesAndRealZones"};

std::string
InverseGhostZoneAttributes::ShowType_ToString(InverseGhostZoneAttributes::ShowType t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return ShowType_strings[index];
}

std::string
InverseGhostZoneAttributes::ShowType_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return ShowType_strings[index];
}

bool
InverseGhostZoneAttributes::ShowType_FromString(const std::string &s, InverseGhostZoneAttributes::ShowType &val)
{
    val = InverseGhostZoneAttributes::GhostZonesOnly;
    for(int i = 0; i < 2; ++i)
    {
        if(s == ShowType_strings[i])
        {
            val = (ShowType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: InverseGhostZoneAttributes::InverseGhostZoneAttributes
//
// Purpose: 
//   Constructor for the InverseGhostZoneAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

InverseGhostZoneAttributes::InverseGhostZoneAttributes() : AttributeSubject("i")
{
    showType = GhostZonesOnly;
}

// ****************************************************************************
// Method: InverseGhostZoneAttributes::InverseGhostZoneAttributes
//
// Purpose: 
//   Copy constructor for the InverseGhostZoneAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

InverseGhostZoneAttributes::InverseGhostZoneAttributes(const InverseGhostZoneAttributes &obj) : AttributeSubject("i")
{
    showType = obj.showType;

    SelectAll();
}

// ****************************************************************************
// Method: InverseGhostZoneAttributes::~InverseGhostZoneAttributes
//
// Purpose: 
//   Destructor for the InverseGhostZoneAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

InverseGhostZoneAttributes::~InverseGhostZoneAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: InverseGhostZoneAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the InverseGhostZoneAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
InverseGhostZoneAttributes::operator = (const InverseGhostZoneAttributes &obj)
{
    showType = obj.showType;

    SelectAll();
}

// ****************************************************************************
// Method: InverseGhostZoneAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the InverseGhostZoneAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
InverseGhostZoneAttributes::operator == (const InverseGhostZoneAttributes &obj) const
{
    // Create the return value
    return ((showType == obj.showType));
}

// ****************************************************************************
// Method: InverseGhostZoneAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the InverseGhostZoneAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
InverseGhostZoneAttributes::operator != (const InverseGhostZoneAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: InverseGhostZoneAttributes::TypeName
//
// Purpose: 
//   Type name method for the InverseGhostZoneAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
InverseGhostZoneAttributes::TypeName() const
{
    return "InverseGhostZoneAttributes";
}

// ****************************************************************************
// Method: InverseGhostZoneAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the InverseGhostZoneAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
InverseGhostZoneAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const InverseGhostZoneAttributes *tmp = (const InverseGhostZoneAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: InverseGhostZoneAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the InverseGhostZoneAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
InverseGhostZoneAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new InverseGhostZoneAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: InverseGhostZoneAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the InverseGhostZoneAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
InverseGhostZoneAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new InverseGhostZoneAttributes(*this);
    else
        retval = new InverseGhostZoneAttributes;

    return retval;
}

// ****************************************************************************
// Method: InverseGhostZoneAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
InverseGhostZoneAttributes::SelectAll()
{
    Select(0, (void *)&showType);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: InverseGhostZoneAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
InverseGhostZoneAttributes::CreateNode(DataNode *parentNode, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    InverseGhostZoneAttributes defaultObject;
    bool addToParent = false;
    // Create a node for InverseGhostZoneAttributes.
    DataNode *node = new DataNode("InverseGhostZoneAttributes");

    if(!FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showType", ShowType_ToString(showType)));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: InverseGhostZoneAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
InverseGhostZoneAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("InverseGhostZoneAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("showType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetShowType(ShowType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            ShowType value;
            if(ShowType_FromString(node->AsString(), value))
                SetShowType(value);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
InverseGhostZoneAttributes::SetShowType(InverseGhostZoneAttributes::ShowType showType_)
{
    showType = showType_;
    Select(0, (void *)&showType);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

InverseGhostZoneAttributes::ShowType
InverseGhostZoneAttributes::GetShowType() const
{
    return ShowType(showType);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: InverseGhostZoneAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
InverseGhostZoneAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Zones to Display:";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: InverseGhostZoneAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
InverseGhostZoneAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: InverseGhostZoneAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
InverseGhostZoneAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: InverseGhostZoneAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 8 09:57:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
InverseGhostZoneAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const InverseGhostZoneAttributes &obj = *((const InverseGhostZoneAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (showType == obj.showType);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

