#include <PyIndexSelectAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyIndexSelectAttributes
//
// Purpose: 
//   This class contains attributes for the index select operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu Jun 6 17:02:08 PST 2002
//
// ****************************************************************************

//
// This struct contains the Python type information and a IndexSelectAttributes.
//
struct IndexSelectAttributesObject
{
    PyObject_HEAD
    IndexSelectAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewIndexSelectAttributes();

static PyObject *
IndexSelectAttributes_Notify(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IndexSelectAttributes_SetDim(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dim in the object.
    obj->data->SetDim(IndexSelectAttributes::Dimension(ival));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IndexSelectAttributes_GetDim(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDim()));
    return retval;
}

static PyObject *
IndexSelectAttributes_SetXMin(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xMin in the object.
    obj->data->SetXMin(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IndexSelectAttributes_GetXMin(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetXMin()));
    return retval;
}

static PyObject *
IndexSelectAttributes_SetXMax(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xMax in the object.
    obj->data->SetXMax(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IndexSelectAttributes_GetXMax(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetXMax()));
    return retval;
}

static PyObject *
IndexSelectAttributes_SetXIncr(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xIncr in the object.
    obj->data->SetXIncr(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IndexSelectAttributes_GetXIncr(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetXIncr()));
    return retval;
}

static PyObject *
IndexSelectAttributes_SetYMin(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yMin in the object.
    obj->data->SetYMin(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IndexSelectAttributes_GetYMin(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetYMin()));
    return retval;
}

static PyObject *
IndexSelectAttributes_SetYMax(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yMax in the object.
    obj->data->SetYMax(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IndexSelectAttributes_GetYMax(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetYMax()));
    return retval;
}

static PyObject *
IndexSelectAttributes_SetYIncr(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yIncr in the object.
    obj->data->SetYIncr(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IndexSelectAttributes_GetYIncr(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetYIncr()));
    return retval;
}

static PyObject *
IndexSelectAttributes_SetZMin(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zMin in the object.
    obj->data->SetZMin(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IndexSelectAttributes_GetZMin(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetZMin()));
    return retval;
}

static PyObject *
IndexSelectAttributes_SetZMax(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zMax in the object.
    obj->data->SetZMax(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IndexSelectAttributes_GetZMax(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetZMax()));
    return retval;
}

static PyObject *
IndexSelectAttributes_SetZIncr(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zIncr in the object.
    obj->data->SetZIncr(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IndexSelectAttributes_GetZIncr(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetZIncr()));
    return retval;
}

static PyObject *
IndexSelectAttributes_SetWhichData(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the whichData in the object.
    obj->data->SetWhichData(IndexSelectAttributes::DataType(ival));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IndexSelectAttributes_GetWhichData(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWhichData()));
    return retval;
}

static PyObject *
IndexSelectAttributes_SetDomainIndex(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the domainIndex in the object.
    obj->data->SetDomainIndex(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IndexSelectAttributes_GetDomainIndex(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDomainIndex()));
    return retval;
}

static PyObject *
IndexSelectAttributes_SetGroupIndex(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the groupIndex in the object.
    obj->data->SetGroupIndex(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
IndexSelectAttributes_GetGroupIndex(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetGroupIndex()));
    return retval;
}



static struct PyMethodDef IndexSelectAttributes_methods[] = {
    {"Notify", IndexSelectAttributes_Notify, METH_VARARGS},
    {"SetDim", IndexSelectAttributes_SetDim, METH_VARARGS},
    {"GetDim", IndexSelectAttributes_GetDim, METH_VARARGS},
    {"SetXMin", IndexSelectAttributes_SetXMin, METH_VARARGS},
    {"GetXMin", IndexSelectAttributes_GetXMin, METH_VARARGS},
    {"SetXMax", IndexSelectAttributes_SetXMax, METH_VARARGS},
    {"GetXMax", IndexSelectAttributes_GetXMax, METH_VARARGS},
    {"SetXIncr", IndexSelectAttributes_SetXIncr, METH_VARARGS},
    {"GetXIncr", IndexSelectAttributes_GetXIncr, METH_VARARGS},
    {"SetYMin", IndexSelectAttributes_SetYMin, METH_VARARGS},
    {"GetYMin", IndexSelectAttributes_GetYMin, METH_VARARGS},
    {"SetYMax", IndexSelectAttributes_SetYMax, METH_VARARGS},
    {"GetYMax", IndexSelectAttributes_GetYMax, METH_VARARGS},
    {"SetYIncr", IndexSelectAttributes_SetYIncr, METH_VARARGS},
    {"GetYIncr", IndexSelectAttributes_GetYIncr, METH_VARARGS},
    {"SetZMin", IndexSelectAttributes_SetZMin, METH_VARARGS},
    {"GetZMin", IndexSelectAttributes_GetZMin, METH_VARARGS},
    {"SetZMax", IndexSelectAttributes_SetZMax, METH_VARARGS},
    {"GetZMax", IndexSelectAttributes_GetZMax, METH_VARARGS},
    {"SetZIncr", IndexSelectAttributes_SetZIncr, METH_VARARGS},
    {"GetZIncr", IndexSelectAttributes_GetZIncr, METH_VARARGS},
    {"SetWhichData", IndexSelectAttributes_SetWhichData, METH_VARARGS},
    {"GetWhichData", IndexSelectAttributes_GetWhichData, METH_VARARGS},
    {"SetDomainIndex", IndexSelectAttributes_SetDomainIndex, METH_VARARGS},
    {"GetDomainIndex", IndexSelectAttributes_GetDomainIndex, METH_VARARGS},
    {"SetGroupIndex", IndexSelectAttributes_SetGroupIndex, METH_VARARGS},
    {"GetGroupIndex", IndexSelectAttributes_GetGroupIndex, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
IndexSelectAttributes_dealloc(PyObject *v)
{
   IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
IndexSelectAttributes_compare(PyObject *v, PyObject *w)
{
    IndexSelectAttributes *a = ((IndexSelectAttributesObject *)v)->data;
    IndexSelectAttributes *b = ((IndexSelectAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
IndexSelectAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "dim") == 0)
        return IndexSelectAttributes_GetDim(self, NULL);
    if(strcmp(name, "OneD") == 0)
        return PyInt_FromLong(long(IndexSelectAttributes::OneD));
    else if(strcmp(name, "TwoD") == 0)
        return PyInt_FromLong(long(IndexSelectAttributes::TwoD));
    else if(strcmp(name, "ThreeD") == 0)
        return PyInt_FromLong(long(IndexSelectAttributes::ThreeD));

    if(strcmp(name, "xMin") == 0)
        return IndexSelectAttributes_GetXMin(self, NULL);
    if(strcmp(name, "xMax") == 0)
        return IndexSelectAttributes_GetXMax(self, NULL);
    if(strcmp(name, "xIncr") == 0)
        return IndexSelectAttributes_GetXIncr(self, NULL);
    if(strcmp(name, "yMin") == 0)
        return IndexSelectAttributes_GetYMin(self, NULL);
    if(strcmp(name, "yMax") == 0)
        return IndexSelectAttributes_GetYMax(self, NULL);
    if(strcmp(name, "yIncr") == 0)
        return IndexSelectAttributes_GetYIncr(self, NULL);
    if(strcmp(name, "zMin") == 0)
        return IndexSelectAttributes_GetZMin(self, NULL);
    if(strcmp(name, "zMax") == 0)
        return IndexSelectAttributes_GetZMax(self, NULL);
    if(strcmp(name, "zIncr") == 0)
        return IndexSelectAttributes_GetZIncr(self, NULL);
    if(strcmp(name, "whichData") == 0)
        return IndexSelectAttributes_GetWhichData(self, NULL);
    if(strcmp(name, "AllDomains") == 0)
        return PyInt_FromLong(long(IndexSelectAttributes::AllDomains));
    else if(strcmp(name, "OneDomain") == 0)
        return PyInt_FromLong(long(IndexSelectAttributes::OneDomain));
    else if(strcmp(name, "OneGroup") == 0)
        return PyInt_FromLong(long(IndexSelectAttributes::OneGroup));

    if(strcmp(name, "domainIndex") == 0)
        return IndexSelectAttributes_GetDomainIndex(self, NULL);
    if(strcmp(name, "groupIndex") == 0)
        return IndexSelectAttributes_GetGroupIndex(self, NULL);

    return Py_FindMethod(IndexSelectAttributes_methods, self, name);
}

static int
IndexSelectAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "dim") == 0)
        retval = (IndexSelectAttributes_SetDim(self, tuple) != NULL);
    else if(strcmp(name, "xMin") == 0)
        retval = (IndexSelectAttributes_SetXMin(self, tuple) != NULL);
    else if(strcmp(name, "xMax") == 0)
        retval = (IndexSelectAttributes_SetXMax(self, tuple) != NULL);
    else if(strcmp(name, "xIncr") == 0)
        retval = (IndexSelectAttributes_SetXIncr(self, tuple) != NULL);
    else if(strcmp(name, "yMin") == 0)
        retval = (IndexSelectAttributes_SetYMin(self, tuple) != NULL);
    else if(strcmp(name, "yMax") == 0)
        retval = (IndexSelectAttributes_SetYMax(self, tuple) != NULL);
    else if(strcmp(name, "yIncr") == 0)
        retval = (IndexSelectAttributes_SetYIncr(self, tuple) != NULL);
    else if(strcmp(name, "zMin") == 0)
        retval = (IndexSelectAttributes_SetZMin(self, tuple) != NULL);
    else if(strcmp(name, "zMax") == 0)
        retval = (IndexSelectAttributes_SetZMax(self, tuple) != NULL);
    else if(strcmp(name, "zIncr") == 0)
        retval = (IndexSelectAttributes_SetZIncr(self, tuple) != NULL);
    else if(strcmp(name, "whichData") == 0)
        retval = (IndexSelectAttributes_SetWhichData(self, tuple) != NULL);
    else if(strcmp(name, "domainIndex") == 0)
        retval = (IndexSelectAttributes_SetDomainIndex(self, tuple) != NULL);
    else if(strcmp(name, "groupIndex") == 0)
        retval = (IndexSelectAttributes_SetGroupIndex(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
IndexSelectAttributes_print(PyObject *v, FILE *fp, int flags)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)v;

    if(obj->data->GetDim() == IndexSelectAttributes::OneD)
        fprintf(fp, "dim = OneD\n");
    else if(obj->data->GetDim() == IndexSelectAttributes::TwoD)
        fprintf(fp, "dim = TwoD\n");
    else
        fprintf(fp, "dim = ThreeD\n");

    fprintf(fp, "xMin = %d\n", obj->data->GetXMin());
    fprintf(fp, "xMax = %d\n", obj->data->GetXMax());
    fprintf(fp, "xIncr = %d\n", obj->data->GetXIncr());
    fprintf(fp, "yMin = %d\n", obj->data->GetYMin());
    fprintf(fp, "yMax = %d\n", obj->data->GetYMax());
    fprintf(fp, "yIncr = %d\n", obj->data->GetYIncr());
    fprintf(fp, "zMin = %d\n", obj->data->GetZMin());
    fprintf(fp, "zMax = %d\n", obj->data->GetZMax());
    fprintf(fp, "zIncr = %d\n", obj->data->GetZIncr());
    if(obj->data->GetWhichData() == IndexSelectAttributes::AllDomains)
        fprintf(fp, "whichData = AllDomains\n");
    else if(obj->data->GetWhichData() == IndexSelectAttributes::OneDomain)
        fprintf(fp, "whichData = OneDomain\n");
    else
        fprintf(fp, "whichData = OneGroup\n");

    fprintf(fp, "domainIndex = %d\n", obj->data->GetDomainIndex());
    fprintf(fp, "groupIndex = %d\n", obj->data->GetGroupIndex());

    return 0;
}

//
// The doc string for the class.
//
static char *IndexSelectAttributes_Purpose = "This class contains attributes for the index select operator.";

//
// The type description structure
//
static PyTypeObject IndexSelectAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "IndexSelectAttributes",                    // tp_name
    sizeof(IndexSelectAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)IndexSelectAttributes_dealloc,  // tp_dealloc
    (printfunc)IndexSelectAttributes_print,     // tp_print
    (getattrfunc)IndexSelectAttributes_getattr, // tp_getattr
    (setattrfunc)IndexSelectAttributes_setattr, // tp_setattr
    (cmpfunc)IndexSelectAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    IndexSelectAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static IndexSelectAttributes *defaultAtts = 0;

static PyObject *
NewIndexSelectAttributes()
{
    IndexSelectAttributesObject *newObject;
    newObject = PyObject_NEW(IndexSelectAttributesObject, &IndexSelectAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new IndexSelectAttributes(*defaultAtts);
    else
        newObject->data = new IndexSelectAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapIndexSelectAttributes(const IndexSelectAttributes *attr)
{
    IndexSelectAttributesObject *newObject;
    newObject = PyObject_NEW(IndexSelectAttributesObject, &IndexSelectAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (IndexSelectAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
IndexSelectAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewIndexSelectAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef IndexSelectAttributesMethods[] = {
    {"IndexSelectAttributes", IndexSelectAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *IndexSelectAttributesObserver = 0;
static bool IndexSelectAttributesEnableLogging = true;

static void
PyIndexSelectAttributes_WriteLog(Subject *subj, void *data)
{
    IndexSelectAttributes *atts = (IndexSelectAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!IndexSelectAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# IndexSelectAttributes_WriteLog()\n");
}

void
PyIndexSelectAttributes_StartUp(IndexSelectAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyIndexSelectAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(IndexSelectAttributesObserver == 0)
    {
        IndexSelectAttributesObserver = new ObserverToCallback(subj,
            PyIndexSelectAttributes_WriteLog, (void *)logFile);
    }

    IndexSelectAttributesEnableLogging = true;
}

void
PyIndexSelectAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete IndexSelectAttributesObserver;
    IndexSelectAttributesObserver = 0;
}

PyMethodDef *
PyIndexSelectAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return IndexSelectAttributesMethods;
}

bool
PyIndexSelectAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &IndexSelectAttributesType);
}

IndexSelectAttributes *
PyIndexSelectAttributes_FromPyObject(PyObject *obj)
{
    IndexSelectAttributesObject *obj2 = (IndexSelectAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyIndexSelectAttributes_NewPyObject()
{
    return NewIndexSelectAttributes();
}

PyObject *
PyIndexSelectAttributes_WrapPyObject(const IndexSelectAttributes *attr)
{
    return WrapIndexSelectAttributes(attr);
}

void
PyIndexSelectAttributes_SetLogging(bool val)
{
    IndexSelectAttributesEnableLogging = val;
}

void
PyIndexSelectAttributes_SetDefaults(const IndexSelectAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new IndexSelectAttributes(*atts);
}

