// ************************************************************************* //
//  File: IndexSelectViewerPluginInfo.C
// ************************************************************************* //

#include <IndexSelectPluginInfo.h>
#include <IndexSelectAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo IndexSelect_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the IndexSelect operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:51 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    IndexSelectViewerPluginInfo::InitializeGlobalObjects();
    return new IndexSelectViewerPluginInfo;
}

//
// Storage for static data elements.
//
IndexSelectAttributes *IndexSelectViewerPluginInfo::clientAtts = NULL;
IndexSelectAttributes *IndexSelectViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  IndexSelectViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:51 PST 2003
//
// ****************************************************************************
void
IndexSelectViewerPluginInfo::InitializeGlobalObjects()
{
    IndexSelectViewerPluginInfo::clientAtts  = new IndexSelectAttributes;
    IndexSelectViewerPluginInfo::defaultAtts = new IndexSelectAttributes;
}

// ****************************************************************************
//  Method: IndexSelectViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:51 PST 2003
//
// ****************************************************************************

AttributeSubject *
IndexSelectViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: IndexSelectViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:51 PST 2003
//
// ****************************************************************************

AttributeSubject *
IndexSelectViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: IndexSelectViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:51 PST 2003
//
// ****************************************************************************

void
IndexSelectViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(IndexSelectAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: IndexSelectViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:51 PST 2003
//
// ****************************************************************************

void
IndexSelectViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(IndexSelectAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: IndexSelectViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:51 PST 2003
//
// ****************************************************************************

void
IndexSelectViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(IndexSelectAttributes*)atts = *defaultAtts;
    else
        *(IndexSelectAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: IndexSelectViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:51 PST 2003
//
// ****************************************************************************

#include <IndexSelect.xpm>
const char **
IndexSelectViewerPluginInfo::XPMIconData() const
{
    return IndexSelect_xpm;
}
