// ************************************************************************* //
//                        IndexSelectScriptingPluginInfo.C
// ************************************************************************* //
#include <IndexSelectPluginInfo.h>
#include <PyIndexSelectAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo IndexSelect_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the IndexSelect plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jun 6 17:02:08 PST 2002
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new IndexSelectScriptingPluginInfo;
}

// ****************************************************************************
// Method: IndexSelectScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jun 6 17:02:08 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
IndexSelectScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyIndexSelectAttributes_StartUp((IndexSelectAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: IndexSelectScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jun 6 17:02:08 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
IndexSelectScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyIndexSelectAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: IndexSelectScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is IndexSelect plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jun 6 17:02:08 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
IndexSelectScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyIndexSelectAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: IndexSelectScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jun 6 17:02:08 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
IndexSelectScriptingPluginInfo::SetLogging(bool val)
{
    PyIndexSelectAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: IndexSelectScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jun 6 17:02:08 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
IndexSelectScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyIndexSelectAttributes_SetDefaults((const IndexSelectAttributes *)atts);
}
