// ************************************************************************* //
//  File: IndexSelectGUIPluginInfo.C
// ************************************************************************* //

#include <IndexSelectPluginInfo.h>
#include <IndexSelectAttributes.h>
#include <QvisIndexSelectWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo IndexSelect_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the IndexSelect operator.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 16:20:30 PST 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new IndexSelectGUIPluginInfo;
}

// ****************************************************************************
//  Method: IndexSelectGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 16:20:30 PST 2003
//
// ****************************************************************************

const char *
IndexSelectGUIPluginInfo::GetMenuName() const
{
    return "Index Select";
}


// ****************************************************************************
//  Method: IndexSelectGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 16:20:30 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
IndexSelectGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisIndexSelectWindow(type, (IndexSelectAttributes *)attr,
        "Index Select operator attributes", "IndexSelect operator", notepad);
}

// ****************************************************************************
//  Method: IndexSelectGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 16:20:30 PST 2003
//
// ****************************************************************************

#include <IndexSelect.xpm>
const char **
IndexSelectGUIPluginInfo::XPMIconData() const
{
    return IndexSelect_xpm;
}
