#include <IndexSelectAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for IndexSelectAttributes::Dimension
//

static const char *Dimension_strings[] = {
"OneD", "TwoD", "ThreeD"
};

std::string
IndexSelectAttributes::Dimension_ToString(IndexSelectAttributes::Dimension t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Dimension_strings[index];
}

std::string
IndexSelectAttributes::Dimension_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Dimension_strings[index];
}

bool
IndexSelectAttributes::Dimension_FromString(const std::string &s, IndexSelectAttributes::Dimension &val)
{
    val = IndexSelectAttributes::OneD;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Dimension_strings[i])
        {
            val = (Dimension)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for IndexSelectAttributes::DataType
//

static const char *DataType_strings[] = {
"AllDomains", "OneDomain", "OneGroup"
};

std::string
IndexSelectAttributes::DataType_ToString(IndexSelectAttributes::DataType t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return DataType_strings[index];
}

std::string
IndexSelectAttributes::DataType_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return DataType_strings[index];
}

bool
IndexSelectAttributes::DataType_FromString(const std::string &s, IndexSelectAttributes::DataType &val)
{
    val = IndexSelectAttributes::AllDomains;
    for(int i = 0; i < 3; ++i)
    {
        if(s == DataType_strings[i])
        {
            val = (DataType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: IndexSelectAttributes::IndexSelectAttributes
//
// Purpose: 
//   Constructor for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

IndexSelectAttributes::IndexSelectAttributes() : AttributeSubject("iiiiiiiiiiiii")
{
    dim = TwoD;
    xMin = 0;
    xMax = -1;
    xIncr = 1;
    yMin = 0;
    yMax = -1;
    yIncr = 1;
    zMin = 0;
    zMax = -1;
    zIncr = 1;
    whichData = AllDomains;
    domainIndex = 0;
    groupIndex = 0;
}

// ****************************************************************************
// Method: IndexSelectAttributes::IndexSelectAttributes
//
// Purpose: 
//   Copy constructor for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

IndexSelectAttributes::IndexSelectAttributes(const IndexSelectAttributes &obj) : AttributeSubject("iiiiiiiiiiiii")
{
    dim = obj.dim;
    xMin = obj.xMin;
    xMax = obj.xMax;
    xIncr = obj.xIncr;
    yMin = obj.yMin;
    yMax = obj.yMax;
    yIncr = obj.yIncr;
    zMin = obj.zMin;
    zMax = obj.zMax;
    zIncr = obj.zIncr;
    whichData = obj.whichData;
    domainIndex = obj.domainIndex;
    groupIndex = obj.groupIndex;

    SelectAll();
}

// ****************************************************************************
// Method: IndexSelectAttributes::~IndexSelectAttributes
//
// Purpose: 
//   Destructor for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

IndexSelectAttributes::~IndexSelectAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: IndexSelectAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
IndexSelectAttributes::operator = (const IndexSelectAttributes &obj)
{
    dim = obj.dim;
    xMin = obj.xMin;
    xMax = obj.xMax;
    xIncr = obj.xIncr;
    yMin = obj.yMin;
    yMax = obj.yMax;
    yIncr = obj.yIncr;
    zMin = obj.zMin;
    zMax = obj.zMax;
    zIncr = obj.zIncr;
    whichData = obj.whichData;
    domainIndex = obj.domainIndex;
    groupIndex = obj.groupIndex;

    SelectAll();
}

// ****************************************************************************
// Method: IndexSelectAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
IndexSelectAttributes::operator == (const IndexSelectAttributes &obj) const
{
    // Create the return value
    return ((dim == obj.dim) &&
            (xMin == obj.xMin) &&
            (xMax == obj.xMax) &&
            (xIncr == obj.xIncr) &&
            (yMin == obj.yMin) &&
            (yMax == obj.yMax) &&
            (yIncr == obj.yIncr) &&
            (zMin == obj.zMin) &&
            (zMax == obj.zMax) &&
            (zIncr == obj.zIncr) &&
            (whichData == obj.whichData) &&
            (domainIndex == obj.domainIndex) &&
            (groupIndex == obj.groupIndex));
}

// ****************************************************************************
// Method: IndexSelectAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
IndexSelectAttributes::operator != (const IndexSelectAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: IndexSelectAttributes::TypeName
//
// Purpose: 
//   Type name method for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
IndexSelectAttributes::TypeName() const
{
    return "IndexSelectAttributes";
}

// ****************************************************************************
// Method: IndexSelectAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
IndexSelectAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const IndexSelectAttributes *tmp = (const IndexSelectAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: IndexSelectAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
IndexSelectAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new IndexSelectAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: IndexSelectAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the IndexSelectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
IndexSelectAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new IndexSelectAttributes(*this);
    else
        retval = new IndexSelectAttributes;

    return retval;
}

// ****************************************************************************
// Method: IndexSelectAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
IndexSelectAttributes::SelectAll()
{
    Select(0, (void *)&dim);
    Select(1, (void *)&xMin);
    Select(2, (void *)&xMax);
    Select(3, (void *)&xIncr);
    Select(4, (void *)&yMin);
    Select(5, (void *)&yMax);
    Select(6, (void *)&yIncr);
    Select(7, (void *)&zMin);
    Select(8, (void *)&zMax);
    Select(9, (void *)&zIncr);
    Select(10, (void *)&whichData);
    Select(11, (void *)&domainIndex);
    Select(12, (void *)&groupIndex);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: IndexSelectAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
IndexSelectAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    IndexSelectAttributes defaultObject;
    bool addToParent = false;
    // Create a node for IndexSelectAttributes.
    DataNode *node = new DataNode("IndexSelectAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("dim", Dimension_ToString(dim)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xMin", xMin));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xMax", xMax));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xIncr", xIncr));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yMin", yMin));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yMax", yMax));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yIncr", yIncr));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zMin", zMin));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zMax", zMax));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zIncr", zIncr));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("whichData", DataType_ToString(whichData)));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("domainIndex", domainIndex));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("groupIndex", groupIndex));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: IndexSelectAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
IndexSelectAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("IndexSelectAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("dim")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetDim(Dimension(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Dimension value;
            if(Dimension_FromString(node->AsString(), value))
                SetDim(value);
        }
    }
    if((node = searchNode->GetNode("xMin")) != 0)
        SetXMin(node->AsInt());
    if((node = searchNode->GetNode("xMax")) != 0)
        SetXMax(node->AsInt());
    if((node = searchNode->GetNode("xIncr")) != 0)
        SetXIncr(node->AsInt());
    if((node = searchNode->GetNode("yMin")) != 0)
        SetYMin(node->AsInt());
    if((node = searchNode->GetNode("yMax")) != 0)
        SetYMax(node->AsInt());
    if((node = searchNode->GetNode("yIncr")) != 0)
        SetYIncr(node->AsInt());
    if((node = searchNode->GetNode("zMin")) != 0)
        SetZMin(node->AsInt());
    if((node = searchNode->GetNode("zMax")) != 0)
        SetZMax(node->AsInt());
    if((node = searchNode->GetNode("zIncr")) != 0)
        SetZIncr(node->AsInt());
    if((node = searchNode->GetNode("whichData")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetWhichData(DataType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            DataType value;
            if(DataType_FromString(node->AsString(), value))
                SetWhichData(value);
        }
    }
    if((node = searchNode->GetNode("domainIndex")) != 0)
        SetDomainIndex(node->AsInt());
    if((node = searchNode->GetNode("groupIndex")) != 0)
        SetGroupIndex(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
IndexSelectAttributes::SetDim(IndexSelectAttributes::Dimension dim_)
{
    dim = dim_;
    Select(0, (void *)&dim);
}

void
IndexSelectAttributes::SetXMin(int xMin_)
{
    xMin = xMin_;
    Select(1, (void *)&xMin);
}

void
IndexSelectAttributes::SetXMax(int xMax_)
{
    xMax = xMax_;
    Select(2, (void *)&xMax);
}

void
IndexSelectAttributes::SetXIncr(int xIncr_)
{
    xIncr = xIncr_;
    Select(3, (void *)&xIncr);
}

void
IndexSelectAttributes::SetYMin(int yMin_)
{
    yMin = yMin_;
    Select(4, (void *)&yMin);
}

void
IndexSelectAttributes::SetYMax(int yMax_)
{
    yMax = yMax_;
    Select(5, (void *)&yMax);
}

void
IndexSelectAttributes::SetYIncr(int yIncr_)
{
    yIncr = yIncr_;
    Select(6, (void *)&yIncr);
}

void
IndexSelectAttributes::SetZMin(int zMin_)
{
    zMin = zMin_;
    Select(7, (void *)&zMin);
}

void
IndexSelectAttributes::SetZMax(int zMax_)
{
    zMax = zMax_;
    Select(8, (void *)&zMax);
}

void
IndexSelectAttributes::SetZIncr(int zIncr_)
{
    zIncr = zIncr_;
    Select(9, (void *)&zIncr);
}

void
IndexSelectAttributes::SetWhichData(IndexSelectAttributes::DataType whichData_)
{
    whichData = whichData_;
    Select(10, (void *)&whichData);
}

void
IndexSelectAttributes::SetDomainIndex(int domainIndex_)
{
    domainIndex = domainIndex_;
    Select(11, (void *)&domainIndex);
}

void
IndexSelectAttributes::SetGroupIndex(int groupIndex_)
{
    groupIndex = groupIndex_;
    Select(12, (void *)&groupIndex);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

IndexSelectAttributes::Dimension
IndexSelectAttributes::GetDim() const
{
    return Dimension(dim);
}

int
IndexSelectAttributes::GetXMin() const
{
    return xMin;
}

int
IndexSelectAttributes::GetXMax() const
{
    return xMax;
}

int
IndexSelectAttributes::GetXIncr() const
{
    return xIncr;
}

int
IndexSelectAttributes::GetYMin() const
{
    return yMin;
}

int
IndexSelectAttributes::GetYMax() const
{
    return yMax;
}

int
IndexSelectAttributes::GetYIncr() const
{
    return yIncr;
}

int
IndexSelectAttributes::GetZMin() const
{
    return zMin;
}

int
IndexSelectAttributes::GetZMax() const
{
    return zMax;
}

int
IndexSelectAttributes::GetZIncr() const
{
    return zIncr;
}

IndexSelectAttributes::DataType
IndexSelectAttributes::GetWhichData() const
{
    return DataType(whichData);
}

int
IndexSelectAttributes::GetDomainIndex() const
{
    return domainIndex;
}

int
IndexSelectAttributes::GetGroupIndex() const
{
    return groupIndex;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: IndexSelectAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
IndexSelectAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Dimension";
        case 1:  return "X-Min";
        case 2:  return "X-Max";
        case 3:  return "X-Incr";
        case 4:  return "Y-Min";
        case 5:  return "Y-Max";
        case 6:  return "Y-Incr";
        case 7:  return "Z-Min";
        case 8:  return "Z-Max";
        case 9:  return "Z-Incr";
        case 10:  return "Which Data";
        case 11:  return "Domain";
        case 12:  return "Group";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: IndexSelectAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
IndexSelectAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_int;
        case 2:  return FieldType_int;
        case 3:  return FieldType_int;
        case 4:  return FieldType_int;
        case 5:  return FieldType_int;
        case 6:  return FieldType_int;
        case 7:  return FieldType_int;
        case 8:  return FieldType_int;
        case 9:  return FieldType_int;
        case 10:  return FieldType_enum;
        case 11:  return FieldType_int;
        case 12:  return FieldType_int;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: IndexSelectAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
IndexSelectAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "int";
        case 2:  return "int";
        case 3:  return "int";
        case 4:  return "int";
        case 5:  return "int";
        case 6:  return "int";
        case 7:  return "int";
        case 8:  return "int";
        case 9:  return "int";
        case 10:  return "enum";
        case 11:  return "int";
        case 12:  return "int";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: IndexSelectAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:49:45 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
IndexSelectAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const IndexSelectAttributes &obj = *((const IndexSelectAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (dim == obj.dim);
        }
        break;
    case 1:
        {  // new scope
        retval = (xMin == obj.xMin);
        }
        break;
    case 2:
        {  // new scope
        retval = (xMax == obj.xMax);
        }
        break;
    case 3:
        {  // new scope
        retval = (xIncr == obj.xIncr);
        }
        break;
    case 4:
        {  // new scope
        retval = (yMin == obj.yMin);
        }
        break;
    case 5:
        {  // new scope
        retval = (yMax == obj.yMax);
        }
        break;
    case 6:
        {  // new scope
        retval = (yIncr == obj.yIncr);
        }
        break;
    case 7:
        {  // new scope
        retval = (zMin == obj.zMin);
        }
        break;
    case 8:
        {  // new scope
        retval = (zMax == obj.zMax);
        }
        break;
    case 9:
        {  // new scope
        retval = (zIncr == obj.zIncr);
        }
        break;
    case 10:
        {  // new scope
        retval = (whichData == obj.whichData);
        }
        break;
    case 11:
        {  // new scope
        retval = (domainIndex == obj.domainIndex);
        }
        break;
    case 12:
        {  // new scope
        retval = (groupIndex == obj.groupIndex);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

