#include <PyExternalSurfaceAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyExternalSurfaceAttributes
//
// Purpose: 
//   This class contains attributes for the external surface operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Sat Aug 3 12:12:58 PDT 2002
//
// ****************************************************************************

//
// This struct contains the Python type information and a ExternalSurfaceAttributes.
//
struct ExternalSurfaceAttributesObject
{
    PyObject_HEAD
    ExternalSurfaceAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewExternalSurfaceAttributes();

static PyObject *
ExternalSurfaceAttributes_Notify(PyObject *self, PyObject *args)
{
    ExternalSurfaceAttributesObject *obj = (ExternalSurfaceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ExternalSurfaceAttributes_SetDummy(PyObject *self, PyObject *args)
{
    ExternalSurfaceAttributesObject *obj = (ExternalSurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dummy in the object.
    obj->data->SetDummy(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ExternalSurfaceAttributes_GetDummy(PyObject *self, PyObject *args)
{
    ExternalSurfaceAttributesObject *obj = (ExternalSurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDummy()?1L:0L);
    return retval;
}



static struct PyMethodDef ExternalSurfaceAttributes_methods[] = {
    {"Notify", ExternalSurfaceAttributes_Notify, METH_VARARGS},
    {"SetDummy", ExternalSurfaceAttributes_SetDummy, METH_VARARGS},
    {"GetDummy", ExternalSurfaceAttributes_GetDummy, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ExternalSurfaceAttributes_dealloc(PyObject *v)
{
   ExternalSurfaceAttributesObject *obj = (ExternalSurfaceAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ExternalSurfaceAttributes_compare(PyObject *v, PyObject *w)
{
    ExternalSurfaceAttributes *a = ((ExternalSurfaceAttributesObject *)v)->data;
    ExternalSurfaceAttributes *b = ((ExternalSurfaceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ExternalSurfaceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "dummy") == 0)
        return ExternalSurfaceAttributes_GetDummy(self, NULL);

    return Py_FindMethod(ExternalSurfaceAttributes_methods, self, name);
}

static int
ExternalSurfaceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "dummy") == 0)
        retval = (ExternalSurfaceAttributes_SetDummy(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ExternalSurfaceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ExternalSurfaceAttributesObject *obj = (ExternalSurfaceAttributesObject *)v;

    if(obj->data->GetDummy())
        fprintf(fp, "dummy = 1\n");
    else
        fprintf(fp, "dummy = 0\n");

    return 0;
}

//
// The doc string for the class.
//
static char *ExternalSurfaceAttributes_Purpose = "This class contains attributes for the external surface operator.";

//
// The type description structure
//
static PyTypeObject ExternalSurfaceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ExternalSurfaceAttributes",                    // tp_name
    sizeof(ExternalSurfaceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ExternalSurfaceAttributes_dealloc,  // tp_dealloc
    (printfunc)ExternalSurfaceAttributes_print,     // tp_print
    (getattrfunc)ExternalSurfaceAttributes_getattr, // tp_getattr
    (setattrfunc)ExternalSurfaceAttributes_setattr, // tp_setattr
    (cmpfunc)ExternalSurfaceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ExternalSurfaceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ExternalSurfaceAttributes *defaultAtts = 0;

static PyObject *
NewExternalSurfaceAttributes()
{
    ExternalSurfaceAttributesObject *newObject;
    newObject = PyObject_NEW(ExternalSurfaceAttributesObject, &ExternalSurfaceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new ExternalSurfaceAttributes(*defaultAtts);
    else
        newObject->data = new ExternalSurfaceAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapExternalSurfaceAttributes(const ExternalSurfaceAttributes *attr)
{
    ExternalSurfaceAttributesObject *newObject;
    newObject = PyObject_NEW(ExternalSurfaceAttributesObject, &ExternalSurfaceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ExternalSurfaceAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ExternalSurfaceAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewExternalSurfaceAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ExternalSurfaceAttributesMethods[] = {
    {"ExternalSurfaceAttributes", ExternalSurfaceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ExternalSurfaceAttributesObserver = 0;
static bool ExternalSurfaceAttributesEnableLogging = true;

static void
PyExternalSurfaceAttributes_WriteLog(Subject *subj, void *data)
{
    ExternalSurfaceAttributes *atts = (ExternalSurfaceAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!ExternalSurfaceAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ExternalSurfaceAttributes_WriteLog()\n");
}

void
PyExternalSurfaceAttributes_StartUp(ExternalSurfaceAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyExternalSurfaceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ExternalSurfaceAttributesObserver == 0)
    {
        ExternalSurfaceAttributesObserver = new ObserverToCallback(subj,
            PyExternalSurfaceAttributes_WriteLog, (void *)logFile);
    }

    ExternalSurfaceAttributesEnableLogging = true;
}

void
PyExternalSurfaceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ExternalSurfaceAttributesObserver;
    ExternalSurfaceAttributesObserver = 0;
}

PyMethodDef *
PyExternalSurfaceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ExternalSurfaceAttributesMethods;
}

bool
PyExternalSurfaceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ExternalSurfaceAttributesType);
}

ExternalSurfaceAttributes *
PyExternalSurfaceAttributes_FromPyObject(PyObject *obj)
{
    ExternalSurfaceAttributesObject *obj2 = (ExternalSurfaceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyExternalSurfaceAttributes_NewPyObject()
{
    return NewExternalSurfaceAttributes();
}

PyObject *
PyExternalSurfaceAttributes_WrapPyObject(const ExternalSurfaceAttributes *attr)
{
    return WrapExternalSurfaceAttributes(attr);
}

void
PyExternalSurfaceAttributes_SetLogging(bool val)
{
    ExternalSurfaceAttributesEnableLogging = val;
}

void
PyExternalSurfaceAttributes_SetDefaults(const ExternalSurfaceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ExternalSurfaceAttributes(*atts);
}

