// ************************************************************************* //
//  File: ExternalSurfaceViewerPluginInfo.C
// ************************************************************************* //

#include <ExternalSurfacePluginInfo.h>
#include <ExternalSurfaceAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo ExternalSurface_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the ExternalSurface operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:37 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    ExternalSurfaceViewerPluginInfo::InitializeGlobalObjects();
    return new ExternalSurfaceViewerPluginInfo;
}

//
// Storage for static data elements.
//
ExternalSurfaceAttributes *ExternalSurfaceViewerPluginInfo::clientAtts = NULL;
ExternalSurfaceAttributes *ExternalSurfaceViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ExternalSurfaceViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:37 PST 2003
//
// ****************************************************************************
void
ExternalSurfaceViewerPluginInfo::InitializeGlobalObjects()
{
    ExternalSurfaceViewerPluginInfo::clientAtts  = new ExternalSurfaceAttributes;
    ExternalSurfaceViewerPluginInfo::defaultAtts = new ExternalSurfaceAttributes;
}

// ****************************************************************************
//  Method: ExternalSurfaceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:37 PST 2003
//
// ****************************************************************************

AttributeSubject *
ExternalSurfaceViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ExternalSurfaceViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:37 PST 2003
//
// ****************************************************************************

AttributeSubject *
ExternalSurfaceViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ExternalSurfaceViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:37 PST 2003
//
// ****************************************************************************

void
ExternalSurfaceViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ExternalSurfaceAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ExternalSurfaceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:37 PST 2003
//
// ****************************************************************************

void
ExternalSurfaceViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ExternalSurfaceAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ExternalSurfaceViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:37 PST 2003
//
// ****************************************************************************

void
ExternalSurfaceViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ExternalSurfaceAttributes*)atts = *defaultAtts;
    else
        *(ExternalSurfaceAttributes*)atts = *clientAtts;
}
