// ************************************************************************* //
//                        ExternalSurfaceScriptingPluginInfo.C
// ************************************************************************* //
#include <ExternalSurfacePluginInfo.h>
#include <PyExternalSurfaceAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo ExternalSurface_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the ExternalSurface plot.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Sat Aug 3 11:48:17 PDT 2002
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new ExternalSurfaceScriptingPluginInfo;
}

// ****************************************************************************
// Method: ExternalSurfaceScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Sat Aug 3 11:48:17 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void
ExternalSurfaceScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyExternalSurfaceAttributes_StartUp((ExternalSurfaceAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: ExternalSurfaceScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Sat Aug 3 11:48:17 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void *
ExternalSurfaceScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyExternalSurfaceAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ExternalSurfaceScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is ExternalSurface plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Sat Aug 3 11:48:17 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

bool
ExternalSurfaceScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyExternalSurfaceAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ExternalSurfaceScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Sat Aug 3 11:48:17 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void
ExternalSurfaceScriptingPluginInfo::SetLogging(bool val)
{
    PyExternalSurfaceAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: ExternalSurfaceScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Sat Aug 3 11:48:17 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void
ExternalSurfaceScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyExternalSurfaceAttributes_SetDefaults((const ExternalSurfaceAttributes *)atts);
}
