// ************************************************************************* //
//  File: ExternalSurfaceGUIPluginInfo.C
// ************************************************************************* //

#include <ExternalSurfacePluginInfo.h>
#include <ExternalSurfaceAttributes.h>
#include <QvisExternalSurfaceWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo ExternalSurface_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the ExternalSurface operator.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Sat Aug 3 11:48:17 PDT 2002
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new ExternalSurfaceGUIPluginInfo;
}

// ****************************************************************************
//  Method: ExternalSurfaceGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Sat Aug 3 11:48:17 PDT 2002
//
// ****************************************************************************

const char *
ExternalSurfaceGUIPluginInfo::GetMenuName() const
{
    return "External Surface";
}


// ****************************************************************************
//  Method: ExternalSurfaceGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Sat Aug 3 11:48:17 PDT 2002
//
// ****************************************************************************

QvisPostableWindowObserver *
ExternalSurfaceGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisExternalSurfaceWindow(type, (ExternalSurfaceAttributes *)attr,
        "External Surface operator attributes", "ExternalSurface operator", notepad);
}
