package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: ExternalSurfaceAttributes
//
// Purpose:
//    This class contains attributes for the external surface operator.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:09:11 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class ExternalSurfaceAttributes extends AttributeSubject implements Plugin
{
    public ExternalSurfaceAttributes()
    {
        super(1);

        dummy = false;
    }

    public ExternalSurfaceAttributes(ExternalSurfaceAttributes obj)
    {
        super(1);

        dummy = obj.dummy;

        SelectAll();
    }

    public boolean equals(ExternalSurfaceAttributes obj)
    {
        // Create the return value
        return ((dummy == obj.dummy));
    }

    public String GetName() { return "ExternalSurface"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetDummy(boolean dummy_)
    {
        dummy = dummy_;
        Select(0);
    }

    // Property getting methods
    public boolean GetDummy() { return dummy; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteBool(dummy);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        buf.ReadByte();
        SetDummy(buf.ReadBool());
    }


    // Attributes
    private boolean dummy;
}

