// ************************************************************************* //
//  File: avtElevateFilter.C
// ************************************************************************* //

#include <avtElevateFilter.h>

#include <avtSurfaceFilter.h>
#include <SurfaceFilterAttributes.h>

// ****************************************************************************
//  Method: avtElevateFilter constructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
// ****************************************************************************

avtElevateFilter::avtElevateFilter()
{
    surface_filter = NULL;
}


// ****************************************************************************
//  Method: avtElevateFilter destructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
//  Modifications:
//
// ****************************************************************************

avtElevateFilter::~avtElevateFilter()
{
    if (surface_filter != NULL)
    {
        delete surface_filter;
        surface_filter = NULL;
    }
}


// ****************************************************************************
//  Method:  avtElevateFilter::Create
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
// ****************************************************************************

avtFilter *
avtElevateFilter::Create()
{
    return new avtElevateFilter();
}


// ****************************************************************************
//  Method:      avtElevateFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
// ****************************************************************************

void
avtElevateFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const ElevateAttributes*)a;
 
    if (surface_filter != NULL)
    {
        delete surface_filter;
    }

    SurfaceFilterAttributes sf_atts;
    sf_atts.SetLimitsMode(
                   (SurfaceFilterAttributes::LimitsMode) atts.GetLimitsMode());
    sf_atts.SetMinFlag(atts.GetMinFlag());
    sf_atts.SetMaxFlag(atts.GetMaxFlag());
    sf_atts.SetScaling((SurfaceFilterAttributes::Scaling) atts.GetScaling());
    sf_atts.SetSkewFactor(atts.GetSkewFactor());
    sf_atts.SetMin(atts.GetMin());
    sf_atts.SetMax(atts.GetMax());
    sf_atts.SetVariable(atts.GetVariable());
    sf_atts.SetUseXYLimits(atts.GetUseXYLimits());
    sf_atts.SetGenerateNodalOutput(false);

    surface_filter = new avtSurfaceFilter(&sf_atts);
}


// ****************************************************************************
//  Method: avtElevateFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtElevateFilter with the given
//      parameters would result in an equivalent avtElevateFilter.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
// ****************************************************************************

bool
avtElevateFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(ElevateAttributes*)a);
}


// ****************************************************************************
//  Method: avtResamplePluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Hank Childs
//  Creation:   January 29, 2005
//
// ****************************************************************************

avtFilter *
avtElevateFilter::GetFacadedFilter(void)
{
    return surface_filter;
}


