#include <PyElevateAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyElevateAttributes
//
// Purpose: 
//   Attributes for the elevate operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Tue Feb 1 11:37:31 PDT 2005
//
// ****************************************************************************

//
// This struct contains the Python type information and a ElevateAttributes.
//
struct ElevateAttributesObject
{
    PyObject_HEAD
    ElevateAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewElevateAttributes();

static PyObject *
ElevateAttributes_Notify(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ElevateAttributes_SetUseXYLimits(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useXYLimits in the object.
    obj->data->SetUseXYLimits(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ElevateAttributes_GetUseXYLimits(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseXYLimits()?1L:0L);
    return retval;
}

static PyObject *
ElevateAttributes_SetLimitsMode(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the limitsMode in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetLimitsMode(ElevateAttributes::LimitsMode(ival));
    else
    {
        fprintf(stderr, "An invalid limitsMode value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "OriginalData, CurrentPlot.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ElevateAttributes_GetLimitsMode(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLimitsMode()));
    return retval;
}

static PyObject *
ElevateAttributes_SetScaling(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetScaling(ElevateAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ElevateAttributes_GetScaling(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScaling()));
    return retval;
}

static PyObject *
ElevateAttributes_SetSkewFactor(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the skewFactor in the object.
    obj->data->SetSkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ElevateAttributes_GetSkewFactor(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSkewFactor());
    return retval;
}

static PyObject *
ElevateAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ElevateAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

static PyObject *
ElevateAttributes_SetMin(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ElevateAttributes_GetMin(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

static PyObject *
ElevateAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ElevateAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

static PyObject *
ElevateAttributes_SetMax(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ElevateAttributes_GetMax(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}

static PyObject *
ElevateAttributes_SetVariable(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the variable in the object.
    obj->data->SetVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ElevateAttributes_GetVariable(PyObject *self, PyObject *args)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVariable().c_str());
    return retval;
}



static struct PyMethodDef ElevateAttributes_methods[] = {
    {"Notify", ElevateAttributes_Notify, METH_VARARGS},
    {"SetUseXYLimits", ElevateAttributes_SetUseXYLimits, METH_VARARGS},
    {"GetUseXYLimits", ElevateAttributes_GetUseXYLimits, METH_VARARGS},
    {"SetLimitsMode", ElevateAttributes_SetLimitsMode, METH_VARARGS},
    {"GetLimitsMode", ElevateAttributes_GetLimitsMode, METH_VARARGS},
    {"SetScaling", ElevateAttributes_SetScaling, METH_VARARGS},
    {"GetScaling", ElevateAttributes_GetScaling, METH_VARARGS},
    {"SetSkewFactor", ElevateAttributes_SetSkewFactor, METH_VARARGS},
    {"GetSkewFactor", ElevateAttributes_GetSkewFactor, METH_VARARGS},
    {"SetMinFlag", ElevateAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", ElevateAttributes_GetMinFlag, METH_VARARGS},
    {"SetMin", ElevateAttributes_SetMin, METH_VARARGS},
    {"GetMin", ElevateAttributes_GetMin, METH_VARARGS},
    {"SetMaxFlag", ElevateAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", ElevateAttributes_GetMaxFlag, METH_VARARGS},
    {"SetMax", ElevateAttributes_SetMax, METH_VARARGS},
    {"GetMax", ElevateAttributes_GetMax, METH_VARARGS},
    {"SetVariable", ElevateAttributes_SetVariable, METH_VARARGS},
    {"GetVariable", ElevateAttributes_GetVariable, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ElevateAttributes_dealloc(PyObject *v)
{
   ElevateAttributesObject *obj = (ElevateAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ElevateAttributes_compare(PyObject *v, PyObject *w)
{
    ElevateAttributes *a = ((ElevateAttributesObject *)v)->data;
    ElevateAttributes *b = ((ElevateAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ElevateAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "useXYLimits") == 0)
        return ElevateAttributes_GetUseXYLimits(self, NULL);
    if(strcmp(name, "limitsMode") == 0)
        return ElevateAttributes_GetLimitsMode(self, NULL);
    if(strcmp(name, "OriginalData") == 0)
        return PyInt_FromLong(long(ElevateAttributes::OriginalData));
    else if(strcmp(name, "CurrentPlot") == 0)
        return PyInt_FromLong(long(ElevateAttributes::CurrentPlot));

    if(strcmp(name, "scaling") == 0)
        return ElevateAttributes_GetScaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(ElevateAttributes::Linear));
    else if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(ElevateAttributes::Log));
    else if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(ElevateAttributes::Skew));

    if(strcmp(name, "skewFactor") == 0)
        return ElevateAttributes_GetSkewFactor(self, NULL);
    if(strcmp(name, "minFlag") == 0)
        return ElevateAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "min") == 0)
        return ElevateAttributes_GetMin(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return ElevateAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "max") == 0)
        return ElevateAttributes_GetMax(self, NULL);
    if(strcmp(name, "variable") == 0)
        return ElevateAttributes_GetVariable(self, NULL);

    return Py_FindMethod(ElevateAttributes_methods, self, name);
}

static int
ElevateAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "useXYLimits") == 0)
        retval = (ElevateAttributes_SetUseXYLimits(self, tuple) != NULL);
    else if(strcmp(name, "limitsMode") == 0)
        retval = (ElevateAttributes_SetLimitsMode(self, tuple) != NULL);
    else if(strcmp(name, "scaling") == 0)
        retval = (ElevateAttributes_SetScaling(self, tuple) != NULL);
    else if(strcmp(name, "skewFactor") == 0)
        retval = (ElevateAttributes_SetSkewFactor(self, tuple) != NULL);
    else if(strcmp(name, "minFlag") == 0)
        retval = (ElevateAttributes_SetMinFlag(self, tuple) != NULL);
    else if(strcmp(name, "min") == 0)
        retval = (ElevateAttributes_SetMin(self, tuple) != NULL);
    else if(strcmp(name, "maxFlag") == 0)
        retval = (ElevateAttributes_SetMaxFlag(self, tuple) != NULL);
    else if(strcmp(name, "max") == 0)
        retval = (ElevateAttributes_SetMax(self, tuple) != NULL);
    else if(strcmp(name, "variable") == 0)
        retval = (ElevateAttributes_SetVariable(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ElevateAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)v;

    if(obj->data->GetUseXYLimits())
        fprintf(fp, "useXYLimits = 1\n");
    else
        fprintf(fp, "useXYLimits = 0\n");
    const char *limitsMode_names = "OriginalData, CurrentPlot";
    if(obj->data->GetLimitsMode() == ElevateAttributes::OriginalData)
        fprintf(fp, "limitsMode = OriginalData  # %s\n", limitsMode_names);
    else
        fprintf(fp, "limitsMode = CurrentPlot  # %s\n", limitsMode_names);

    const char *scaling_names = "Linear, Log, Skew";
    if(obj->data->GetScaling() == ElevateAttributes::Linear)
        fprintf(fp, "scaling = Linear  # %s\n", scaling_names);
    else if(obj->data->GetScaling() == ElevateAttributes::Log)
        fprintf(fp, "scaling = Log  # %s\n", scaling_names);
    else
        fprintf(fp, "scaling = Skew  # %s\n", scaling_names);

    fprintf(fp, "skewFactor = %g\n", obj->data->GetSkewFactor());
    if(obj->data->GetMinFlag())
        fprintf(fp, "minFlag = 1\n");
    else
        fprintf(fp, "minFlag = 0\n");
    fprintf(fp, "min = %g\n", obj->data->GetMin());
    if(obj->data->GetMaxFlag())
        fprintf(fp, "maxFlag = 1\n");
    else
        fprintf(fp, "maxFlag = 0\n");
    fprintf(fp, "max = %g\n", obj->data->GetMax());
    fprintf(fp, "variable = \"%s\"\n", obj->data->GetVariable().c_str());

    return 0;
}

#include <snprintf.h>
PyObject *
PyElevateAttributes_StringRepresentation(const ElevateAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    if(atts->GetUseXYLimits())
        SNPRINTF(tmpStr, 1000, "useXYLimits = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "useXYLimits = 0\n");
    str += tmpStr;
    const char *limitsMode_names = "OriginalData, CurrentPlot";
    if(atts->GetLimitsMode() == ElevateAttributes::OriginalData)
        {
             SNPRINTF(tmpStr, 1000, "limitsMode = OriginalData  # %s\n", limitsMode_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "limitsMode = CurrentPlot  # %s\n", limitsMode_names);
             str += tmpStr;
        }

    const char *scaling_names = "Linear, Log, Skew";
    if(atts->GetScaling() == ElevateAttributes::Linear)
        {
             SNPRINTF(tmpStr, 1000, "scaling = Linear  # %s\n", scaling_names);
             str += tmpStr;
        }
    else if(atts->GetScaling() == ElevateAttributes::Log)
        {
             SNPRINTF(tmpStr, 1000, "scaling = Log  # %s\n", scaling_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "scaling = Skew  # %s\n", scaling_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "skewFactor = %g\n", atts->GetSkewFactor());
    str += tmpStr;
    if(atts->GetMinFlag())
        SNPRINTF(tmpStr, 1000, "minFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "minFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "min = %g\n", atts->GetMin());
    str += tmpStr;
    if(atts->GetMaxFlag())
        SNPRINTF(tmpStr, 1000, "maxFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "maxFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "max = %g\n", atts->GetMax());
    str += tmpStr;
   SNPRINTF(tmpStr, 1000, "variable = \"%s\"\n", atts->GetVariable().c_str());
   str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
ElevateAttributes_str(PyObject *v)
{
    ElevateAttributesObject *obj = (ElevateAttributesObject *)v;
    return PyElevateAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *ElevateAttributes_Purpose = "Attributes for the elevate operator";

//
// The type description structure
//
static PyTypeObject ElevateAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ElevateAttributes",                    // tp_name
    sizeof(ElevateAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ElevateAttributes_dealloc,  // tp_dealloc
    (printfunc)ElevateAttributes_print,     // tp_print
    (getattrfunc)ElevateAttributes_getattr, // tp_getattr
    (setattrfunc)ElevateAttributes_setattr, // tp_setattr
    (cmpfunc)ElevateAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ElevateAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ElevateAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ElevateAttributes *defaultAtts = 0;

static PyObject *
NewElevateAttributes()
{
    ElevateAttributesObject *newObject;
    newObject = PyObject_NEW(ElevateAttributesObject, &ElevateAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new ElevateAttributes(*defaultAtts);
    else
        newObject->data = new ElevateAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapElevateAttributes(const ElevateAttributes *attr)
{
    ElevateAttributesObject *newObject;
    newObject = PyObject_NEW(ElevateAttributesObject, &ElevateAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ElevateAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ElevateAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewElevateAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ElevateAttributesMethods[] = {
    {"ElevateAttributes", ElevateAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ElevateAttributesObserver = 0;
static bool ElevateAttributesEnableLogging = true;

static void
PyElevateAttributes_WriteLog(Subject *subj, void *data)
{
    ElevateAttributes *atts = (ElevateAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!ElevateAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ElevateAttributes_WriteLog()\n");
}

void
PyElevateAttributes_StartUp(ElevateAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyElevateAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ElevateAttributesObserver == 0)
    {
        ElevateAttributesObserver = new ObserverToCallback(subj,
            PyElevateAttributes_WriteLog, (void *)logFile);
    }

    ElevateAttributesEnableLogging = true;
}

void
PyElevateAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ElevateAttributesObserver;
    ElevateAttributesObserver = 0;
}

PyMethodDef *
PyElevateAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ElevateAttributesMethods;
}

bool
PyElevateAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ElevateAttributesType);
}

ElevateAttributes *
PyElevateAttributes_FromPyObject(PyObject *obj)
{
    ElevateAttributesObject *obj2 = (ElevateAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyElevateAttributes_NewPyObject()
{
    return NewElevateAttributes();
}

PyObject *
PyElevateAttributes_WrapPyObject(const ElevateAttributes *attr)
{
    return WrapElevateAttributes(attr);
}

void
PyElevateAttributes_SetLogging(bool val)
{
    ElevateAttributesEnableLogging = val;
}

void
PyElevateAttributes_SetDefaults(const ElevateAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ElevateAttributes(*atts);
}

