// ************************************************************************* //
//  File: ElevateViewerPluginInfo.C
// ************************************************************************* //

#include <ElevatePluginInfo.h>
#include <ElevateAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Elevate_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Elevate operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    ElevateViewerPluginInfo::InitializeGlobalObjects();
    return new ElevateViewerPluginInfo;
}

//
// Storage for static data elements.
//
ElevateAttributes *ElevateViewerPluginInfo::clientAtts = NULL;
ElevateAttributes *ElevateViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ElevateViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// ****************************************************************************
void
ElevateViewerPluginInfo::InitializeGlobalObjects()
{
    ElevateViewerPluginInfo::clientAtts  = new ElevateAttributes;
    ElevateViewerPluginInfo::defaultAtts = new ElevateAttributes;
}

// ****************************************************************************
//  Method: ElevateViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// ****************************************************************************

AttributeSubject *
ElevateViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ElevateViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// ****************************************************************************

AttributeSubject *
ElevateViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ElevateViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// ****************************************************************************

void
ElevateViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ElevateAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ElevateViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// ****************************************************************************

void
ElevateViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ElevateAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ElevateViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// ****************************************************************************

void
ElevateViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ElevateAttributes*)atts = *defaultAtts;
    else
        *(ElevateAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ElevateViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// ****************************************************************************

#include <Elevate.xpm>
const char **
ElevateViewerPluginInfo::XPMIconData() const
{
    return Elevate_xpm;
}
