// ************************************************************************* //
//                        ElevateScriptingPluginInfo.C
// ************************************************************************* //
#include <ElevatePluginInfo.h>
#include <PyElevateAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Elevate_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Elevate plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new ElevateScriptingPluginInfo;
}

// ****************************************************************************
// Method: ElevateScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

void
ElevateScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyElevateAttributes_StartUp((ElevateAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: ElevateScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

void *
ElevateScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyElevateAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ElevateScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Elevate plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
ElevateScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyElevateAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ElevateScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

void
ElevateScriptingPluginInfo::SetLogging(bool val)
{
    PyElevateAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: ElevateScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

void
ElevateScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyElevateAttributes_SetDefaults((const ElevateAttributes *)atts);
}
