// ************************************************************************* //
//  File: ElevateGUIPluginInfo.C
// ************************************************************************* //

#include <ElevatePluginInfo.h>
#include <ElevateAttributes.h>
#include <QvisElevateWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Elevate_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Elevate operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new ElevateGUIPluginInfo;
}

// ****************************************************************************
//  Method: ElevateGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// ****************************************************************************

const char *
ElevateGUIPluginInfo::GetMenuName() const
{
    return "Elevate";
}


// ****************************************************************************
//  Method: ElevateGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// ****************************************************************************

QvisPostableWindowObserver *
ElevateGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisElevateWindow(type, (ElevateAttributes *)attr,
        "Elevate operator attributes", "Elevate operator", notepad);
}

// ****************************************************************************
//  Method: ElevateGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// ****************************************************************************

#include <Elevate.xpm>
const char **
ElevateGUIPluginInfo::XPMIconData() const
{
    return Elevate_xpm;
}
