#ifndef ELEVATEATTRIBUTES_H
#define ELEVATEATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: ElevateAttributes
//
// Purpose:
//    Attributes for the elevate operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

class ElevateAttributes : public AttributeSubject
{
public:
    enum Scaling
    {
        Linear,
        Log,
        Skew
    };
    enum LimitsMode
    {
        OriginalData,
        CurrentPlot
    };

    ElevateAttributes();
    ElevateAttributes(const ElevateAttributes &obj);
    virtual ~ElevateAttributes();

    virtual ElevateAttributes& operator = (const ElevateAttributes &obj);
    virtual bool operator == (const ElevateAttributes &obj) const;
    virtual bool operator != (const ElevateAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectVariable();

    // Property setting methods
    void SetUseXYLimits(bool useXYLimits_);
    void SetLimitsMode(LimitsMode limitsMode_);
    void SetScaling(Scaling scaling_);
    void SetSkewFactor(double skewFactor_);
    void SetMinFlag(bool minFlag_);
    void SetMin(double min_);
    void SetMaxFlag(bool maxFlag_);
    void SetMax(double max_);
    void SetVariable(const std::string &variable_);

    // Property getting methods
    bool              GetUseXYLimits() const;
    LimitsMode        GetLimitsMode() const;
    Scaling           GetScaling() const;
    double            GetSkewFactor() const;
    bool              GetMinFlag() const;
    double            GetMin() const;
    bool              GetMaxFlag() const;
    double            GetMax() const;
    const std::string &GetVariable() const;
          std::string &GetVariable();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string Scaling_ToString(Scaling);
    static bool Scaling_FromString(const std::string &, Scaling &);
protected:
    static std::string Scaling_ToString(int);
public:
    static std::string LimitsMode_ToString(LimitsMode);
    static bool LimitsMode_FromString(const std::string &, LimitsMode &);
protected:
    static std::string LimitsMode_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    bool        useXYLimits;
    int         limitsMode;
    int         scaling;
    double      skewFactor;
    bool        minFlag;
    double      min;
    bool        maxFlag;
    double      max;
    std::string variable;
};

#endif
