#include <ElevateAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for ElevateAttributes::Scaling
//

static const char *Scaling_strings[] = {
"Linear", "Log", "Skew"
};

std::string
ElevateAttributes::Scaling_ToString(ElevateAttributes::Scaling t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Scaling_strings[index];
}

std::string
ElevateAttributes::Scaling_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Scaling_strings[index];
}

bool
ElevateAttributes::Scaling_FromString(const std::string &s, ElevateAttributes::Scaling &val)
{
    val = ElevateAttributes::Linear;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Scaling_strings[i])
        {
            val = (Scaling)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for ElevateAttributes::LimitsMode
//

static const char *LimitsMode_strings[] = {
"OriginalData", "CurrentPlot"};

std::string
ElevateAttributes::LimitsMode_ToString(ElevateAttributes::LimitsMode t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return LimitsMode_strings[index];
}

std::string
ElevateAttributes::LimitsMode_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return LimitsMode_strings[index];
}

bool
ElevateAttributes::LimitsMode_FromString(const std::string &s, ElevateAttributes::LimitsMode &val)
{
    val = ElevateAttributes::OriginalData;
    for(int i = 0; i < 2; ++i)
    {
        if(s == LimitsMode_strings[i])
        {
            val = (LimitsMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: ElevateAttributes::ElevateAttributes
//
// Purpose: 
//   Constructor for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

ElevateAttributes::ElevateAttributes() : AttributeSubject("biidbdbds"),
    variable("default")
{
    useXYLimits = false;
    limitsMode = OriginalData;
    scaling = Linear;
    skewFactor = 1;
    minFlag = false;
    min = 0;
    maxFlag = false;
    max = 1;
}

// ****************************************************************************
// Method: ElevateAttributes::ElevateAttributes
//
// Purpose: 
//   Copy constructor for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

ElevateAttributes::ElevateAttributes(const ElevateAttributes &obj) : AttributeSubject("biidbdbds")
{
    useXYLimits = obj.useXYLimits;
    limitsMode = obj.limitsMode;
    scaling = obj.scaling;
    skewFactor = obj.skewFactor;
    minFlag = obj.minFlag;
    min = obj.min;
    maxFlag = obj.maxFlag;
    max = obj.max;
    variable = obj.variable;

    SelectAll();
}

// ****************************************************************************
// Method: ElevateAttributes::~ElevateAttributes
//
// Purpose: 
//   Destructor for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

ElevateAttributes::~ElevateAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ElevateAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

ElevateAttributes& 
ElevateAttributes::operator = (const ElevateAttributes &obj)
{
    if (this == &obj) return *this;
    useXYLimits = obj.useXYLimits;
    limitsMode = obj.limitsMode;
    scaling = obj.scaling;
    skewFactor = obj.skewFactor;
    minFlag = obj.minFlag;
    min = obj.min;
    maxFlag = obj.maxFlag;
    max = obj.max;
    variable = obj.variable;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: ElevateAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
ElevateAttributes::operator == (const ElevateAttributes &obj) const
{
    // Create the return value
    return ((useXYLimits == obj.useXYLimits) &&
            (limitsMode == obj.limitsMode) &&
            (scaling == obj.scaling) &&
            (skewFactor == obj.skewFactor) &&
            (minFlag == obj.minFlag) &&
            (min == obj.min) &&
            (maxFlag == obj.maxFlag) &&
            (max == obj.max) &&
            (variable == obj.variable));
}

// ****************************************************************************
// Method: ElevateAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
ElevateAttributes::operator != (const ElevateAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ElevateAttributes::TypeName
//
// Purpose: 
//   Type name method for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

const std::string
ElevateAttributes::TypeName() const
{
    return "ElevateAttributes";
}

// ****************************************************************************
// Method: ElevateAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
ElevateAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ElevateAttributes *tmp = (const ElevateAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ElevateAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ElevateAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ElevateAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ElevateAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ElevateAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ElevateAttributes(*this);
    else
        retval = new ElevateAttributes;

    return retval;
}

// ****************************************************************************
// Method: ElevateAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

void
ElevateAttributes::SelectAll()
{
    Select(0, (void *)&useXYLimits);
    Select(1, (void *)&limitsMode);
    Select(2, (void *)&scaling);
    Select(3, (void *)&skewFactor);
    Select(4, (void *)&minFlag);
    Select(5, (void *)&min);
    Select(6, (void *)&maxFlag);
    Select(7, (void *)&max);
    Select(8, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ElevateAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
ElevateAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ElevateAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ElevateAttributes.
    DataNode *node = new DataNode("ElevateAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useXYLimits", useXYLimits));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("limitsMode", LimitsMode_ToString(limitsMode)));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaling", Scaling_ToString(scaling)));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("skewFactor", skewFactor));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minFlag", minFlag));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("min", min));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxFlag", maxFlag));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("max", max));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("variable", variable));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ElevateAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

void
ElevateAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ElevateAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("useXYLimits")) != 0)
        SetUseXYLimits(node->AsBool());
    if((node = searchNode->GetNode("limitsMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetLimitsMode(LimitsMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            LimitsMode value;
            if(LimitsMode_FromString(node->AsString(), value))
                SetLimitsMode(value);
        }
    }
    if((node = searchNode->GetNode("scaling")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetScaling(Scaling(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Scaling value;
            if(Scaling_FromString(node->AsString(), value))
                SetScaling(value);
        }
    }
    if((node = searchNode->GetNode("skewFactor")) != 0)
        SetSkewFactor(node->AsDouble());
    if((node = searchNode->GetNode("minFlag")) != 0)
        SetMinFlag(node->AsBool());
    if((node = searchNode->GetNode("min")) != 0)
        SetMin(node->AsDouble());
    if((node = searchNode->GetNode("maxFlag")) != 0)
        SetMaxFlag(node->AsBool());
    if((node = searchNode->GetNode("max")) != 0)
        SetMax(node->AsDouble());
    if((node = searchNode->GetNode("variable")) != 0)
        SetVariable(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ElevateAttributes::SetUseXYLimits(bool useXYLimits_)
{
    useXYLimits = useXYLimits_;
    Select(0, (void *)&useXYLimits);
}

void
ElevateAttributes::SetLimitsMode(ElevateAttributes::LimitsMode limitsMode_)
{
    limitsMode = limitsMode_;
    Select(1, (void *)&limitsMode);
}

void
ElevateAttributes::SetScaling(ElevateAttributes::Scaling scaling_)
{
    scaling = scaling_;
    Select(2, (void *)&scaling);
}

void
ElevateAttributes::SetSkewFactor(double skewFactor_)
{
    skewFactor = skewFactor_;
    Select(3, (void *)&skewFactor);
}

void
ElevateAttributes::SetMinFlag(bool minFlag_)
{
    minFlag = minFlag_;
    Select(4, (void *)&minFlag);
}

void
ElevateAttributes::SetMin(double min_)
{
    min = min_;
    Select(5, (void *)&min);
}

void
ElevateAttributes::SetMaxFlag(bool maxFlag_)
{
    maxFlag = maxFlag_;
    Select(6, (void *)&maxFlag);
}

void
ElevateAttributes::SetMax(double max_)
{
    max = max_;
    Select(7, (void *)&max);
}

void
ElevateAttributes::SetVariable(const std::string &variable_)
{
    variable = variable_;
    Select(8, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
ElevateAttributes::GetUseXYLimits() const
{
    return useXYLimits;
}

ElevateAttributes::LimitsMode
ElevateAttributes::GetLimitsMode() const
{
    return LimitsMode(limitsMode);
}

ElevateAttributes::Scaling
ElevateAttributes::GetScaling() const
{
    return Scaling(scaling);
}

double
ElevateAttributes::GetSkewFactor() const
{
    return skewFactor;
}

bool
ElevateAttributes::GetMinFlag() const
{
    return minFlag;
}

double
ElevateAttributes::GetMin() const
{
    return min;
}

bool
ElevateAttributes::GetMaxFlag() const
{
    return maxFlag;
}

double
ElevateAttributes::GetMax() const
{
    return max;
}

const std::string &
ElevateAttributes::GetVariable() const
{
    return variable;
}

std::string &
ElevateAttributes::GetVariable()
{
    return variable;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ElevateAttributes::SelectVariable()
{
    Select(8, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ElevateAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
ElevateAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Elevation height based on XY limits?";
        case 1:  return "LimitsMode";
        case 2:  return "Scale";
        case 3:  return "Skew factor";
        case 4:  return "Use min";
        case 5:  return "Min";
        case 6:  return "Use max";
        case 7:  return "Max";
        case 8:  return "Elevate by Variable";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ElevateAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ElevateAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_bool;
        case 1:  return FieldType_enum;
        case 2:  return FieldType_enum;
        case 3:  return FieldType_double;
        case 4:  return FieldType_bool;
        case 5:  return FieldType_double;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_double;
        case 8:  return FieldType_variablename;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ElevateAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
ElevateAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "bool";
        case 1:  return "enum";
        case 2:  return "enum";
        case 3:  return "double";
        case 4:  return "bool";
        case 5:  return "double";
        case 6:  return "bool";
        case 7:  return "double";
        case 8:  return "variablename";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ElevateAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Feb 1 11:37:30 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
ElevateAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ElevateAttributes &obj = *((const ElevateAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (useXYLimits == obj.useXYLimits);
        }
        break;
    case 1:
        {  // new scope
        retval = (limitsMode == obj.limitsMode);
        }
        break;
    case 2:
        {  // new scope
        retval = (scaling == obj.scaling);
        }
        break;
    case 3:
        {  // new scope
        retval = (skewFactor == obj.skewFactor);
        }
        break;
    case 4:
        {  // new scope
        retval = (minFlag == obj.minFlag);
        }
        break;
    case 5:
        {  // new scope
        retval = (min == obj.min);
        }
        break;
    case 6:
        {  // new scope
        retval = (maxFlag == obj.maxFlag);
        }
        break;
    case 7:
        {  // new scope
        retval = (max == obj.max);
        }
        break;
    case 8:
        {  // new scope
        retval = (variable == obj.variable);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

