// ************************************************************************* //
//  File: avtDisplaceFilter.C
// ************************************************************************* //

#include <avtDisplaceFilter.h>

#include <vtkCellData.h>
#include <vtkCellDataToPointData.h>
#include <vtkPointData.h>
#include <vtkPointSet.h>
#include <vtkRectilinearGrid.h>
#include <vtkStructuredGrid.h>
#include <vtkWarpVector.h>

#include <avtDatasetExaminer.h>
#include <avtExtents.h>

#include <DebugStream.h>
#include <ImproperUseException.h>


// ****************************************************************************
//  Method: avtDisplaceFilter constructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Nov 5 15:35:46 PST 2001
//
//  Modifications:
//
//    Hank Childs, Tue Jun 29 07:59:53 PDT 2004
//    Removed initialization of issuedWarning; data member has been removed.
//
// ****************************************************************************

avtDisplaceFilter::avtDisplaceFilter()
{
    OverrideTrueSpatialExtents();
}


// ****************************************************************************
//  Method: avtDisplaceFilter destructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Nov 5 15:35:46 PST 2001
//
//  Modifications:
//
// ****************************************************************************

avtDisplaceFilter::~avtDisplaceFilter()
{
}


// ****************************************************************************
//  Method:  avtDisplaceFilter::Create
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Nov 5 15:35:46 PST 2001
//
// ****************************************************************************

avtFilter *
avtDisplaceFilter::Create()
{
    return new avtDisplaceFilter();
}


// ****************************************************************************
//  Method:      avtDisplaceFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Nov 5 15:35:46 PST 2001
//
// ****************************************************************************

void
avtDisplaceFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const DisplaceAttributes*)a;
    SetActiveVariable(atts.GetVariable().c_str());
}


// ****************************************************************************
//  Method: avtDisplaceFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtDisplaceFilter with the given
//      parameters would result in an equivalent avtDisplaceFilter.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Nov 5 15:35:46 PST 2001
//
// ****************************************************************************

bool
avtDisplaceFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(DisplaceAttributes*)a);
}


// ****************************************************************************
//  Method: avtDisplaceFilter::ExecuteData
//
//  Purpose:
//      Sends the specified input and output through the Displace filter.
//
//  Arguments:
//      in_ds      The input dataset.
//      <unused>   The domain number.
//      <unused>   The label.
//
//  Returns:       The output dataset.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Nov 5 15:35:46 PST 2001
//
//  Modifications:
//    Kathleen Bonnell, Fri Feb  8 11:03:49 PST 2002
//    vtkVectors has been deprecated in VTK 4.0, use vtkDataArray instead.
//
//    Hank Childs, Wed Sep 11 08:34:03 PDT 2002
//    Fixed memory leak.
//
//    Hank Childs, Thu May  6 10:04:26 PDT 2004
//    Operate on rectilinear grids as well.
//
//    Hank Childs, Tue Jun 29 07:21:32 PDT 2004
//    Do not issue a warning if we get cell centered data.
//
// ****************************************************************************

vtkDataSet *
avtDisplaceFilter::ExecuteData(vtkDataSet *in_ds, int, std::string)
{
    vtkCellDataToPointData *cd2pd = NULL;

    in_ds->GetPointData()->SetActiveVectors(atts.GetVariable().c_str());
    vtkDataArray *vecs = in_ds->GetPointData()->GetVectors();

    //
    // If we didn't get a vector variable, then see if there is a cell
    // centered vector variable and interpolate that to the nodes.
    //
    if (vecs == NULL)
    {
        cd2pd = vtkCellDataToPointData::New();
        cd2pd->SetInput(in_ds);
        cd2pd->GetOutput()->Update();
        vtkDataSet *new_in_ds = cd2pd->GetOutput();
        new_in_ds->Update();
        new_in_ds->SetSource(NULL);
        vtkPointData *pd = in_ds->GetPointData();
        for (int i = 0 ; i < pd->GetNumberOfArrays() ; i++)
        {
            new_in_ds->GetPointData()->AddArray(pd->GetArray(i));
        }

        in_ds->GetCellData()->SetActiveVectors(atts.GetVariable().c_str());
        vecs = new_in_ds->GetPointData()->GetVectors();

        if (vecs == NULL)
        {
            EXCEPTION0(ImproperUseException);
        }
        in_ds = new_in_ds;
    }

    vtkDataSet *rv = NULL;
    if (in_ds->GetDataObjectType() == VTK_POLY_DATA 
        || in_ds->GetDataObjectType() == VTK_STRUCTURED_GRID 
        || in_ds->GetDataObjectType() == VTK_UNSTRUCTURED_GRID)
    {
        vtkWarpVector *warp = vtkWarpVector::New();
        warp->SetInput((vtkPointSet *)in_ds);
        warp->SetScaleFactor(atts.GetFactor());
        rv = warp->GetOutput();
        rv->Update();

        //
        // Make this a dataset we can return even after we have freed memory.
        //
        ManageMemory(rv);

        warp->Delete();
    }
    else if (in_ds->GetDataObjectType() == VTK_RECTILINEAR_GRID)
    {
        vtkRectilinearGrid *rg = (vtkRectilinearGrid *) in_ds;
        vtkStructuredGrid *sg  = vtkStructuredGrid::New();
        int dims[3];
        rg->GetDimensions(dims);
        sg->SetDimensions(dims);
        sg->GetCellData()->ShallowCopy(rg->GetCellData());
        sg->GetPointData()->ShallowCopy(rg->GetPointData());
        vtkPoints *pts = vtkPoints::New();
        int npts = dims[0]*dims[1]*dims[2];
        pts->SetNumberOfPoints(npts);
        float factor = atts.GetFactor();
        for (int i = 0 ; i < npts ; i++)
        {
            int xi = i % dims[0];
            int yi = (i / dims[0]) % dims[1];
            int zi = i / (dims[0]*dims[1]);
            float x = rg->GetXCoordinates()->GetTuple1(xi);
            float y = rg->GetYCoordinates()->GetTuple1(yi);
            float z = rg->GetZCoordinates()->GetTuple1(zi);
            float *vec = vecs->GetTuple3(i);
            x += factor*vec[0];
            y += factor*vec[1];
            z += factor*vec[2];
            pts->SetPoint(i, x, y, z);
        }
        sg->SetPoints(pts);
        pts->Delete();
 
        rv = sg;
        ManageMemory(rv);
        sg->Delete();
    }
    else
    {
        debug1 << "Unable to determine dataset type for displace operator" 
               << endl;
        EXCEPTION0(ImproperUseException);
    }


    //
    // Clean up memory.
    //
    if (cd2pd != NULL)
    {
        cd2pd->Delete();
    }

    return rv;
}


// ****************************************************************************
//  Method: avtDisplaceFilter::PostExecute
//
//  Purpose:
//      Finds the extents once we have been transformed and set those.
//
//  Programmer: Hank Childs
//  Creation:   May 24, 2004
//
// ****************************************************************************

void
avtDisplaceFilter::PostExecute(void)
{
    avtPluginStreamer::PostExecute();

    avtDataAttributes& outAtts = GetOutput()->GetInfo().GetAttributes();

    // get the outputs's spatial extents
    double se[6];
    avtDataset_p output = GetTypedOutput();
    avtDatasetExaminer::GetSpatialExtents(output, se);

    // over-write spatial extents
    outAtts.GetTrueSpatialExtents()->Clear();
    outAtts.GetCumulativeTrueSpatialExtents()->Set(se);
}


// ****************************************************************************
//  Method: avtDisplaceFilter::RefashionDataObjectInfo
//
//  Purpose:
//    Indicates that the nodes were transformed.
//
//  Programmer: Kathleen Bonnell
//  Creation:   November 28, 2001
//
//  Modificatons:
//    Kathleen Bonnell, Mon Apr 14 09:54:06 PDT 2003
//    Set CanUseTransform to false.
//
//    Kathleen Bonnell, Wed Jun  2 09:21:46 PDT 2004 
//    Set CanUseInvTransform to false.
//
// ****************************************************************************

void
avtDisplaceFilter::RefashionDataObjectInfo(void)
{
    GetOutput()->GetInfo().GetValidity().SetPointsWereTransformed(true);
    //
    // This operator invalidates any transform matrix in the pipeline.
    //
    GetOutput()->GetInfo().GetAttributes().SetCanUseTransform(false);
    GetOutput()->GetInfo().GetAttributes().SetCanUseInvTransform(false);
}


// ****************************************************************************
//  Method: avtDisplaceFilter::PerformRestriction
//
//  Purpose:
//    Turn on Zone numbers flag if needed, so that original cell array
//    will be propagated throught the pipeline.
//
//  Programmer: Kathleen Bonnell
//  Creation:   November 28, 2001
//
//  Modifications:
//    Kathleen Bonnell, Wed Jun 19 12:28:10 PDT 2002 
//    Don't turn off Zone numbers if they have been turned on elsewhere in
//    the pipeline.
//
//    Kathleen Bonnell, Wed Jun 19 13:42:37 PDT 2002
//    Completely removed the code turning off zone numbers.  Why set a flag
//    to false if it is already false?  False is the default setting.
//
//    Kathleen Bonnell, Wed Jun  2 09:21:46 PDT 2004 
//    Turn on node numbers when required.
//
// ****************************************************************************

avtPipelineSpecification_p
avtDisplaceFilter::PerformRestriction(avtPipelineSpecification_p spec)
{
    avtPipelineSpecification_p rv = new avtPipelineSpecification(spec);
    if (rv->GetDataSpecification()->MayRequireZones())
    {
        rv->GetDataSpecification()->TurnZoneNumbersOn();
    }
    if (rv->GetDataSpecification()->MayRequireNodes())
    {
        rv->GetDataSpecification()->TurnNodeNumbersOn();
    }
    return rv;
}

