#include <PyDisplaceAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyDisplaceAttributes
//
// Purpose: 
//   This class contains attributes for the displace operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu Dec 9 15:21:51 PST 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a DisplaceAttributes.
//
struct DisplaceAttributesObject
{
    PyObject_HEAD
    DisplaceAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewDisplaceAttributes();

static PyObject *
DisplaceAttributes_Notify(PyObject *self, PyObject *args)
{
    DisplaceAttributesObject *obj = (DisplaceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
DisplaceAttributes_SetFactor(PyObject *self, PyObject *args)
{
    DisplaceAttributesObject *obj = (DisplaceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the factor in the object.
    obj->data->SetFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
DisplaceAttributes_GetFactor(PyObject *self, PyObject *args)
{
    DisplaceAttributesObject *obj = (DisplaceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetFactor());
    return retval;
}

static PyObject *
DisplaceAttributes_SetVariable(PyObject *self, PyObject *args)
{
    DisplaceAttributesObject *obj = (DisplaceAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the variable in the object.
    obj->data->SetVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
DisplaceAttributes_GetVariable(PyObject *self, PyObject *args)
{
    DisplaceAttributesObject *obj = (DisplaceAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVariable().c_str());
    return retval;
}



static struct PyMethodDef DisplaceAttributes_methods[] = {
    {"Notify", DisplaceAttributes_Notify, METH_VARARGS},
    {"SetFactor", DisplaceAttributes_SetFactor, METH_VARARGS},
    {"GetFactor", DisplaceAttributes_GetFactor, METH_VARARGS},
    {"SetVariable", DisplaceAttributes_SetVariable, METH_VARARGS},
    {"GetVariable", DisplaceAttributes_GetVariable, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
DisplaceAttributes_dealloc(PyObject *v)
{
   DisplaceAttributesObject *obj = (DisplaceAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
DisplaceAttributes_compare(PyObject *v, PyObject *w)
{
    DisplaceAttributes *a = ((DisplaceAttributesObject *)v)->data;
    DisplaceAttributes *b = ((DisplaceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
DisplaceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "factor") == 0)
        return DisplaceAttributes_GetFactor(self, NULL);
    if(strcmp(name, "variable") == 0)
        return DisplaceAttributes_GetVariable(self, NULL);

    return Py_FindMethod(DisplaceAttributes_methods, self, name);
}

static int
DisplaceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "factor") == 0)
        retval = (DisplaceAttributes_SetFactor(self, tuple) != NULL);
    else if(strcmp(name, "variable") == 0)
        retval = (DisplaceAttributes_SetVariable(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
DisplaceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    DisplaceAttributesObject *obj = (DisplaceAttributesObject *)v;

    fprintf(fp, "factor = %g\n", obj->data->GetFactor());
    fprintf(fp, "variable = \"%s\"\n", obj->data->GetVariable().c_str());

    return 0;
}

#include <snprintf.h>
PyObject *
PyDisplaceAttributes_StringRepresentation(const DisplaceAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "factor = %g\n", atts->GetFactor());
    str += tmpStr;
   SNPRINTF(tmpStr, 1000, "variable = \"%s\"\n", atts->GetVariable().c_str());
   str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
DisplaceAttributes_str(PyObject *v)
{
    DisplaceAttributesObject *obj = (DisplaceAttributesObject *)v;
    return PyDisplaceAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *DisplaceAttributes_Purpose = "This class contains attributes for the displace operator.";

//
// The type description structure
//
static PyTypeObject DisplaceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "DisplaceAttributes",                    // tp_name
    sizeof(DisplaceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)DisplaceAttributes_dealloc,  // tp_dealloc
    (printfunc)DisplaceAttributes_print,     // tp_print
    (getattrfunc)DisplaceAttributes_getattr, // tp_getattr
    (setattrfunc)DisplaceAttributes_setattr, // tp_setattr
    (cmpfunc)DisplaceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)DisplaceAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    DisplaceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static DisplaceAttributes *defaultAtts = 0;

static PyObject *
NewDisplaceAttributes()
{
    DisplaceAttributesObject *newObject;
    newObject = PyObject_NEW(DisplaceAttributesObject, &DisplaceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new DisplaceAttributes(*defaultAtts);
    else
        newObject->data = new DisplaceAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapDisplaceAttributes(const DisplaceAttributes *attr)
{
    DisplaceAttributesObject *newObject;
    newObject = PyObject_NEW(DisplaceAttributesObject, &DisplaceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (DisplaceAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
DisplaceAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewDisplaceAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef DisplaceAttributesMethods[] = {
    {"DisplaceAttributes", DisplaceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *DisplaceAttributesObserver = 0;
static bool DisplaceAttributesEnableLogging = true;

static void
PyDisplaceAttributes_WriteLog(Subject *subj, void *data)
{
    DisplaceAttributes *atts = (DisplaceAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!DisplaceAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# DisplaceAttributes_WriteLog()\n");
}

void
PyDisplaceAttributes_StartUp(DisplaceAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyDisplaceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(DisplaceAttributesObserver == 0)
    {
        DisplaceAttributesObserver = new ObserverToCallback(subj,
            PyDisplaceAttributes_WriteLog, (void *)logFile);
    }

    DisplaceAttributesEnableLogging = true;
}

void
PyDisplaceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete DisplaceAttributesObserver;
    DisplaceAttributesObserver = 0;
}

PyMethodDef *
PyDisplaceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return DisplaceAttributesMethods;
}

bool
PyDisplaceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &DisplaceAttributesType);
}

DisplaceAttributes *
PyDisplaceAttributes_FromPyObject(PyObject *obj)
{
    DisplaceAttributesObject *obj2 = (DisplaceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyDisplaceAttributes_NewPyObject()
{
    return NewDisplaceAttributes();
}

PyObject *
PyDisplaceAttributes_WrapPyObject(const DisplaceAttributes *attr)
{
    return WrapDisplaceAttributes(attr);
}

void
PyDisplaceAttributes_SetLogging(bool val)
{
    DisplaceAttributesEnableLogging = val;
}

void
PyDisplaceAttributes_SetDefaults(const DisplaceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new DisplaceAttributes(*atts);
}

