// ************************************************************************* //
//  File: DisplaceViewerPluginInfo.C
// ************************************************************************* //

#include <DisplacePluginInfo.h>
#include <DisplaceAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Displace_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Displace operator.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    DisplaceViewerPluginInfo::InitializeGlobalObjects();
    return new DisplaceViewerPluginInfo;
}

//
// Storage for static data elements.
//
DisplaceAttributes *DisplaceViewerPluginInfo::clientAtts = NULL;
DisplaceAttributes *DisplaceViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  DisplaceViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// ****************************************************************************
void
DisplaceViewerPluginInfo::InitializeGlobalObjects()
{
    DisplaceViewerPluginInfo::clientAtts  = new DisplaceAttributes;
    DisplaceViewerPluginInfo::defaultAtts = new DisplaceAttributes;
}

// ****************************************************************************
//  Method: DisplaceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// ****************************************************************************

AttributeSubject *
DisplaceViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: DisplaceViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// ****************************************************************************

AttributeSubject *
DisplaceViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: DisplaceViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// ****************************************************************************

void
DisplaceViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(DisplaceAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: DisplaceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// ****************************************************************************

void
DisplaceViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(DisplaceAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: DisplaceViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// ****************************************************************************

void
DisplaceViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(DisplaceAttributes*)atts = *defaultAtts;
    else
        *(DisplaceAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: DisplaceViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// ****************************************************************************

#include <Displace.xpm>
const char **
DisplaceViewerPluginInfo::XPMIconData() const
{
    return Displace_xpm;
}
