// ************************************************************************* //
//                        DisplaceScriptingPluginInfo.C
// ************************************************************************* //
#include <DisplacePluginInfo.h>
#include <PyDisplaceAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Displace_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Displace plot.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new DisplaceScriptingPluginInfo;
}

// ****************************************************************************
// Method: DisplaceScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
DisplaceScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyDisplaceAttributes_StartUp((DisplaceAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: DisplaceScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void *
DisplaceScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyDisplaceAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: DisplaceScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Displace plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
DisplaceScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyDisplaceAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: DisplaceScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
DisplaceScriptingPluginInfo::SetLogging(bool val)
{
    PyDisplaceAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: DisplaceScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
DisplaceScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyDisplaceAttributes_SetDefaults((const DisplaceAttributes *)atts);
}
