// ************************************************************************* //
//  File: DisplaceGUIPluginInfo.C
// ************************************************************************* //

#include <DisplacePluginInfo.h>
#include <DisplaceAttributes.h>
#include <QvisDisplaceWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Displace_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Displace operator.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new DisplaceGUIPluginInfo;
}

// ****************************************************************************
//  Method: DisplaceGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// ****************************************************************************

const char *
DisplaceGUIPluginInfo::GetMenuName() const
{
    return "Displace";
}


// ****************************************************************************
//  Method: DisplaceGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// ****************************************************************************

QvisPostableWindowObserver *
DisplaceGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisDisplaceWindow(type, (DisplaceAttributes *)attr,
        "Displace operator attributes", "Displace operator", notepad);
}

// ****************************************************************************
//  Method: DisplaceGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 19 12:19:23 PDT 2004
//
// ****************************************************************************

#include <Displace.xpm>
const char **
DisplaceGUIPluginInfo::XPMIconData() const
{
    return Displace_xpm;
}
