// ************************************************************************* //
//  File: avtDecimateFilter.C
// ************************************************************************* //

#include <avtDecimateFilter.h>

#include <vtkDecimatePro.h>
#include <vtkPolyData.h>
#include <vtkTriangleFilter.h>

#include <avtCallback.h>


// ****************************************************************************
//  Method: avtDecimateFilter constructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sun Aug 11 08:02:03 PDT 2002
//
// ****************************************************************************

avtDecimateFilter::avtDecimateFilter()
{
    haveIssuedWarning = false;
}


// ****************************************************************************
//  Method: avtDecimateFilter destructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sun Aug 11 08:02:03 PDT 2002
//
//  Modifications:
//
// ****************************************************************************

avtDecimateFilter::~avtDecimateFilter()
{
}


// ****************************************************************************
//  Method:  avtDecimateFilter::Create
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sun Aug 11 08:02:03 PDT 2002
//
// ****************************************************************************

avtFilter *
avtDecimateFilter::Create()
{
    return new avtDecimateFilter();
}


// ****************************************************************************
//  Method:      avtDecimateFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sun Aug 11 08:02:03 PDT 2002
//
// ****************************************************************************

void
avtDecimateFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const DecimateAttributes*)a;
}


// ****************************************************************************
//  Method: avtDecimateFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtDecimateFilter with the given
//      parameters would result in an equivalent avtDecimateFilter.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sun Aug 11 08:02:03 PDT 2002
//
// ****************************************************************************

bool
avtDecimateFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(DecimateAttributes*)a);
}


// ****************************************************************************
//  Method: avtDecimateFilter::ExecuteData
//
//  Purpose:
//      Sends the specified input and output through the Decimate filter.
//
//  Arguments:
//      in_ds      The input dataset.
//      <unused>   The domain number.
//
//  Returns:       The output dataset.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sun Aug 11 08:02:03 PDT 2002
//
//  Modifications:
//
//    Hank Childs, Fri Sep  6 07:55:49 PDT 2002
//    Triangulate all of the surfaces before decimating (the filter crashes
//    otherwise).
//
// ****************************************************************************

vtkDataSet *
avtDecimateFilter::ExecuteData(vtkDataSet *in_ds, int, std::string)
{
    if (in_ds->GetDataObjectType() != VTK_POLY_DATA)
    {
        if (!haveIssuedWarning)
        {
            avtCallback::IssueWarning("The Decimation operator can only be "
                    "applied to polygonal data.  It is not being applied.");
            haveIssuedWarning = true;
        }
        return in_ds;
    }

    vtkPolyData *pd = (vtkPolyData *) in_ds;

    vtkTriangleFilter *triangulator = vtkTriangleFilter::New();
    triangulator->SetInput(pd);

    vtkDecimatePro *decimate = vtkDecimatePro::New();
    decimate->SetInput(triangulator->GetOutput());
    decimate->SetTargetReduction(atts.GetTarget());
    vtkDataSet *output = decimate->GetOutput();
    output->Update();

    ManageMemory(output);

    decimate->Delete();
    triangulator->Delete();

    return output;
}


