#include <PyDecimateAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyDecimateAttributes
//
// Purpose: 
//   This class contains attributes for the decimate operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Sun Aug 11 08:39:31 PDT 2002
//
// ****************************************************************************

//
// This struct contains the Python type information and a DecimateAttributes.
//
struct DecimateAttributesObject
{
    PyObject_HEAD
    DecimateAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewDecimateAttributes();

static PyObject *
DecimateAttributes_Notify(PyObject *self, PyObject *args)
{
    DecimateAttributesObject *obj = (DecimateAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
DecimateAttributes_SetTarget(PyObject *self, PyObject *args)
{
    DecimateAttributesObject *obj = (DecimateAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the target in the object.
    obj->data->SetTarget(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
DecimateAttributes_GetTarget(PyObject *self, PyObject *args)
{
    DecimateAttributesObject *obj = (DecimateAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTarget());
    return retval;
}



static struct PyMethodDef DecimateAttributes_methods[] = {
    {"Notify", DecimateAttributes_Notify, METH_VARARGS},
    {"SetTarget", DecimateAttributes_SetTarget, METH_VARARGS},
    {"GetTarget", DecimateAttributes_GetTarget, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
DecimateAttributes_dealloc(PyObject *v)
{
   DecimateAttributesObject *obj = (DecimateAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
DecimateAttributes_compare(PyObject *v, PyObject *w)
{
    DecimateAttributes *a = ((DecimateAttributesObject *)v)->data;
    DecimateAttributes *b = ((DecimateAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
DecimateAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "target") == 0)
        return DecimateAttributes_GetTarget(self, NULL);

    return Py_FindMethod(DecimateAttributes_methods, self, name);
}

static int
DecimateAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "target") == 0)
        retval = (DecimateAttributes_SetTarget(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
DecimateAttributes_print(PyObject *v, FILE *fp, int flags)
{
    DecimateAttributesObject *obj = (DecimateAttributesObject *)v;

    fprintf(fp, "target = %g\n", obj->data->GetTarget());

    return 0;
}

//
// The doc string for the class.
//
static char *DecimateAttributes_Purpose = "This class contains attributes for the decimate operator.";

//
// The type description structure
//
static PyTypeObject DecimateAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "DecimateAttributes",                    // tp_name
    sizeof(DecimateAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)DecimateAttributes_dealloc,  // tp_dealloc
    (printfunc)DecimateAttributes_print,     // tp_print
    (getattrfunc)DecimateAttributes_getattr, // tp_getattr
    (setattrfunc)DecimateAttributes_setattr, // tp_setattr
    (cmpfunc)DecimateAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    DecimateAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static DecimateAttributes *defaultAtts = 0;

static PyObject *
NewDecimateAttributes()
{
    DecimateAttributesObject *newObject;
    newObject = PyObject_NEW(DecimateAttributesObject, &DecimateAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new DecimateAttributes(*defaultAtts);
    else
        newObject->data = new DecimateAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapDecimateAttributes(const DecimateAttributes *attr)
{
    DecimateAttributesObject *newObject;
    newObject = PyObject_NEW(DecimateAttributesObject, &DecimateAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (DecimateAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
DecimateAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewDecimateAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef DecimateAttributesMethods[] = {
    {"DecimateAttributes", DecimateAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *DecimateAttributesObserver = 0;
static bool DecimateAttributesEnableLogging = true;

static void
PyDecimateAttributes_WriteLog(Subject *subj, void *data)
{
    DecimateAttributes *atts = (DecimateAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!DecimateAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# DecimateAttributes_WriteLog()\n");
}

void
PyDecimateAttributes_StartUp(DecimateAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyDecimateAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(DecimateAttributesObserver == 0)
    {
        DecimateAttributesObserver = new ObserverToCallback(subj,
            PyDecimateAttributes_WriteLog, (void *)logFile);
    }

    DecimateAttributesEnableLogging = true;
}

void
PyDecimateAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete DecimateAttributesObserver;
    DecimateAttributesObserver = 0;
}

PyMethodDef *
PyDecimateAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return DecimateAttributesMethods;
}

bool
PyDecimateAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &DecimateAttributesType);
}

DecimateAttributes *
PyDecimateAttributes_FromPyObject(PyObject *obj)
{
    DecimateAttributesObject *obj2 = (DecimateAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyDecimateAttributes_NewPyObject()
{
    return NewDecimateAttributes();
}

PyObject *
PyDecimateAttributes_WrapPyObject(const DecimateAttributes *attr)
{
    return WrapDecimateAttributes(attr);
}

void
PyDecimateAttributes_SetLogging(bool val)
{
    DecimateAttributesEnableLogging = val;
}

void
PyDecimateAttributes_SetDefaults(const DecimateAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new DecimateAttributes(*atts);
}

