// ************************************************************************* //
//  File: DecimateViewerPluginInfo.C
// ************************************************************************* //

#include <DecimatePluginInfo.h>
#include <DecimateAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Decimate_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Decimate operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:14 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    DecimateViewerPluginInfo::InitializeGlobalObjects();
    return new DecimateViewerPluginInfo;
}

//
// Storage for static data elements.
//
DecimateAttributes *DecimateViewerPluginInfo::clientAtts = NULL;
DecimateAttributes *DecimateViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  DecimateViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:14 PST 2003
//
// ****************************************************************************
void
DecimateViewerPluginInfo::InitializeGlobalObjects()
{
    DecimateViewerPluginInfo::clientAtts  = new DecimateAttributes;
    DecimateViewerPluginInfo::defaultAtts = new DecimateAttributes;
}

// ****************************************************************************
//  Method: DecimateViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:14 PST 2003
//
// ****************************************************************************

AttributeSubject *
DecimateViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: DecimateViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:14 PST 2003
//
// ****************************************************************************

AttributeSubject *
DecimateViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: DecimateViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:14 PST 2003
//
// ****************************************************************************

void
DecimateViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(DecimateAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: DecimateViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:14 PST 2003
//
// ****************************************************************************

void
DecimateViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(DecimateAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: DecimateViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:02:14 PST 2003
//
// ****************************************************************************

void
DecimateViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(DecimateAttributes*)atts = *defaultAtts;
    else
        *(DecimateAttributes*)atts = *clientAtts;
}
