// ************************************************************************* //
//                        DecimateScriptingPluginInfo.C
// ************************************************************************* //
#include <DecimatePluginInfo.h>
#include <PyDecimateAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Decimate_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Decimate plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sun Aug 11 08:39:31 PDT 2002
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new DecimateScriptingPluginInfo;
}

// ****************************************************************************
// Method: DecimateScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sun Aug 11 08:39:31 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void
DecimateScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyDecimateAttributes_StartUp((DecimateAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: DecimateScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sun Aug 11 08:39:31 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void *
DecimateScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyDecimateAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: DecimateScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Decimate plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sun Aug 11 08:39:31 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

bool
DecimateScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyDecimateAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: DecimateScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sun Aug 11 08:39:31 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void
DecimateScriptingPluginInfo::SetLogging(bool val)
{
    PyDecimateAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: DecimateScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sun Aug 11 08:39:31 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void
DecimateScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyDecimateAttributes_SetDefaults((const DecimateAttributes *)atts);
}
