// ************************************************************************* //
//  File: DecimateGUIPluginInfo.C
// ************************************************************************* //

#include <DecimatePluginInfo.h>
#include <DecimateAttributes.h>
#include <QvisDecimateWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Decimate_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Decimate operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sun Aug 11 08:39:31 PDT 2002
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new DecimateGUIPluginInfo;
}

// ****************************************************************************
//  Method: DecimateGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sun Aug 11 08:39:31 PDT 2002
//
// ****************************************************************************

const char *
DecimateGUIPluginInfo::GetMenuName() const
{
    return "Decimate";
}


// ****************************************************************************
//  Method: DecimateGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Sun Aug 11 08:39:31 PDT 2002
//
// ****************************************************************************

QvisPostableWindowObserver *
DecimateGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisDecimateWindow(type, (DecimateAttributes *)attr,
        "Decimate operator attributes", "Decimate operator", notepad);
}
