#include <PyCylinderAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyCylinderAttributes
//
// Purpose: 
//   Contain the attributes for a cylinder
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Tue Oct 21 13:17:15 PST 2003
//
// ****************************************************************************

//
// This struct contains the Python type information and a CylinderAttributes.
//
struct CylinderAttributesObject
{
    PyObject_HEAD
    CylinderAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewCylinderAttributes();

static PyObject *
CylinderAttributes_Notify(PyObject *self, PyObject *args)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CylinderAttributes_SetPoint1(PyObject *self, PyObject *args)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)self;

    double *dvals = obj->data->GetPoint1();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the point1 in the object as modified.
    obj->data->SelectPoint1();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CylinderAttributes_GetPoint1(PyObject *self, PyObject *args)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the point1.
    PyObject *retval = PyTuple_New(3);
    const double *point1 = obj->data->GetPoint1();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(point1[i]));
    return retval;
}

static PyObject *
CylinderAttributes_SetPoint2(PyObject *self, PyObject *args)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)self;

    double *dvals = obj->data->GetPoint2();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the point2 in the object as modified.
    obj->data->SelectPoint2();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CylinderAttributes_GetPoint2(PyObject *self, PyObject *args)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the point2.
    PyObject *retval = PyTuple_New(3);
    const double *point2 = obj->data->GetPoint2();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(point2[i]));
    return retval;
}

static PyObject *
CylinderAttributes_SetRadius(PyObject *self, PyObject *args)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the radius in the object.
    obj->data->SetRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CylinderAttributes_GetRadius(PyObject *self, PyObject *args)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRadius());
    return retval;
}



static struct PyMethodDef CylinderAttributes_methods[] = {
    {"Notify", CylinderAttributes_Notify, METH_VARARGS},
    {"SetPoint1", CylinderAttributes_SetPoint1, METH_VARARGS},
    {"GetPoint1", CylinderAttributes_GetPoint1, METH_VARARGS},
    {"SetPoint2", CylinderAttributes_SetPoint2, METH_VARARGS},
    {"GetPoint2", CylinderAttributes_GetPoint2, METH_VARARGS},
    {"SetRadius", CylinderAttributes_SetRadius, METH_VARARGS},
    {"GetRadius", CylinderAttributes_GetRadius, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
CylinderAttributes_dealloc(PyObject *v)
{
   CylinderAttributesObject *obj = (CylinderAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
CylinderAttributes_compare(PyObject *v, PyObject *w)
{
    CylinderAttributes *a = ((CylinderAttributesObject *)v)->data;
    CylinderAttributes *b = ((CylinderAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
CylinderAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "point1") == 0)
        return CylinderAttributes_GetPoint1(self, NULL);
    if(strcmp(name, "point2") == 0)
        return CylinderAttributes_GetPoint2(self, NULL);
    if(strcmp(name, "radius") == 0)
        return CylinderAttributes_GetRadius(self, NULL);

    return Py_FindMethod(CylinderAttributes_methods, self, name);
}

static int
CylinderAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "point1") == 0)
        retval = (CylinderAttributes_SetPoint1(self, tuple) != NULL);
    else if(strcmp(name, "point2") == 0)
        retval = (CylinderAttributes_SetPoint2(self, tuple) != NULL);
    else if(strcmp(name, "radius") == 0)
        retval = (CylinderAttributes_SetRadius(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
CylinderAttributes_print(PyObject *v, FILE *fp, int flags)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)v;

    {   const double *point1 = obj->data->GetPoint1();
        fprintf(fp, "point1 = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", point1[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *point2 = obj->data->GetPoint2();
        fprintf(fp, "point2 = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", point2[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "radius = %g\n", obj->data->GetRadius());

    return 0;
}

//
// The doc string for the class.
//
static char *CylinderAttributes_Purpose = "Contain the attributes for a cylinder";

//
// The type description structure
//
static PyTypeObject CylinderAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "CylinderAttributes",                    // tp_name
    sizeof(CylinderAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)CylinderAttributes_dealloc,  // tp_dealloc
    (printfunc)CylinderAttributes_print,     // tp_print
    (getattrfunc)CylinderAttributes_getattr, // tp_getattr
    (setattrfunc)CylinderAttributes_setattr, // tp_setattr
    (cmpfunc)CylinderAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    CylinderAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static CylinderAttributes *defaultAtts = 0;

static PyObject *
NewCylinderAttributes()
{
    CylinderAttributesObject *newObject;
    newObject = PyObject_NEW(CylinderAttributesObject, &CylinderAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new CylinderAttributes(*defaultAtts);
    else
        newObject->data = new CylinderAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapCylinderAttributes(const CylinderAttributes *attr)
{
    CylinderAttributesObject *newObject;
    newObject = PyObject_NEW(CylinderAttributesObject, &CylinderAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (CylinderAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
CylinderAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewCylinderAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef CylinderAttributesMethods[] = {
    {"CylinderAttributes", CylinderAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *CylinderAttributesObserver = 0;
static bool CylinderAttributesEnableLogging = true;

static void
PyCylinderAttributes_WriteLog(Subject *subj, void *data)
{
    CylinderAttributes *atts = (CylinderAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!CylinderAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# CylinderAttributes_WriteLog()\n");
}

void
PyCylinderAttributes_StartUp(CylinderAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyCylinderAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(CylinderAttributesObserver == 0)
    {
        CylinderAttributesObserver = new ObserverToCallback(subj,
            PyCylinderAttributes_WriteLog, (void *)logFile);
    }

    CylinderAttributesEnableLogging = true;
}

void
PyCylinderAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete CylinderAttributesObserver;
    CylinderAttributesObserver = 0;
}

PyMethodDef *
PyCylinderAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return CylinderAttributesMethods;
}

bool
PyCylinderAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &CylinderAttributesType);
}

CylinderAttributes *
PyCylinderAttributes_FromPyObject(PyObject *obj)
{
    CylinderAttributesObject *obj2 = (CylinderAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyCylinderAttributes_NewPyObject()
{
    return NewCylinderAttributes();
}

PyObject *
PyCylinderAttributes_WrapPyObject(const CylinderAttributes *attr)
{
    return WrapCylinderAttributes(attr);
}

void
PyCylinderAttributes_SetLogging(bool val)
{
    CylinderAttributesEnableLogging = val;
}

void
PyCylinderAttributes_SetDefaults(const CylinderAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new CylinderAttributes(*atts);
}

