// ************************************************************************* //
//  File: CylinderViewerPluginInfo.C
// ************************************************************************* //

#include <CylinderPluginInfo.h>
#include <CylinderAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Cylinder_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Cylinder operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 21 13:17:14 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    CylinderViewerPluginInfo::InitializeGlobalObjects();
    return new CylinderViewerPluginInfo;
}

//
// Storage for static data elements.
//
CylinderAttributes *CylinderViewerPluginInfo::clientAtts = NULL;
CylinderAttributes *CylinderViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  CylinderViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 21 13:17:14 PST 2003
//
// ****************************************************************************
void
CylinderViewerPluginInfo::InitializeGlobalObjects()
{
    CylinderViewerPluginInfo::clientAtts  = new CylinderAttributes;
    CylinderViewerPluginInfo::defaultAtts = new CylinderAttributes;
}

// ****************************************************************************
//  Method: CylinderViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 21 13:17:14 PST 2003
//
// ****************************************************************************

AttributeSubject *
CylinderViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: CylinderViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 21 13:17:14 PST 2003
//
// ****************************************************************************

AttributeSubject *
CylinderViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: CylinderViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 21 13:17:14 PST 2003
//
// ****************************************************************************

void
CylinderViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(CylinderAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: CylinderViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 21 13:17:14 PST 2003
//
// ****************************************************************************

void
CylinderViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(CylinderAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: CylinderViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 21 13:17:14 PST 2003
//
// ****************************************************************************

void
CylinderViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(CylinderAttributes*)atts = *defaultAtts;
    else
        *(CylinderAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: CylinderViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 21 13:17:14 PST 2003
//
// ****************************************************************************

#include <Cylinder.xpm>
const char **
CylinderViewerPluginInfo::XPMIconData() const
{
    return Cylinder_xpm;
}
