// ************************************************************************* //
//  File: CylinderPluginInfo.h
// ************************************************************************* //

#ifndef CYLINDER_PLUGIN_INFO_H
#define CYLINDER_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class CylinderAttributes;

// ****************************************************************************
//  Class: CylinderPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Cylinder operator
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 21 13:17:14 PST 2003
//
//  Modifications:
//
// ****************************************************************************

class CylinderGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
};

class CylinderCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual CylinderGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class CylinderGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual CylinderCommonPluginInfo
{
  public:
    virtual const char *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class CylinderViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual CylinderCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const ViewerPlot *plot,
                                        const bool fromDefault);
    virtual const char **XPMIconData() const;

    static void InitializeGlobalObjects();
  private:
    static CylinderAttributes *defaultAtts;
    static CylinderAttributes *clientAtts;
};

class CylinderEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual CylinderCommonPluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class CylinderScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual CylinderCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, FILE *log);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual void SetLogging(bool val);
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
