// ************************************************************************* //
//  File: CylinderGUIPluginInfo.C
// ************************************************************************* //

#include <CylinderPluginInfo.h>
#include <CylinderAttributes.h>
#include <QvisCylinderWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Cylinder_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Cylinder operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 21 13:17:14 PST 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new CylinderGUIPluginInfo;
}

// ****************************************************************************
//  Method: CylinderGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 21 13:17:14 PST 2003
//
// ****************************************************************************

const char *
CylinderGUIPluginInfo::GetMenuName() const
{
    return "Cylinder";
}


// ****************************************************************************
//  Method: CylinderGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 21 13:17:14 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
CylinderGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisCylinderWindow(type, (CylinderAttributes *)attr,
        "Cylinder operator attributes", "Cylinder operator", notepad);
}

// ****************************************************************************
//  Method: CylinderGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 21 13:17:14 PST 2003
//
// ****************************************************************************

#include <Cylinder.xpm>
const char **
CylinderGUIPluginInfo::XPMIconData() const
{
    return Cylinder_xpm;
}
