#include <PyCoordSwapAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyCoordSwapAttributes
//
// Purpose: 
//   This class contains attributes for the coord swap operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Wed Feb 2 16:09:10 PST 2005
//
// ****************************************************************************

//
// This struct contains the Python type information and a CoordSwapAttributes.
//
struct CoordSwapAttributesObject
{
    PyObject_HEAD
    CoordSwapAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewCoordSwapAttributes();

static PyObject *
CoordSwapAttributes_Notify(PyObject *self, PyObject *args)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CoordSwapAttributes_SetNewCoord1(PyObject *self, PyObject *args)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the newCoord1 in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetNewCoord1(CoordSwapAttributes::Coord(ival));
    else
    {
        fprintf(stderr, "An invalid newCoord1 value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Coord1, Coord2, Coord3.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CoordSwapAttributes_GetNewCoord1(PyObject *self, PyObject *args)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNewCoord1()));
    return retval;
}

static PyObject *
CoordSwapAttributes_SetNewCoord2(PyObject *self, PyObject *args)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the newCoord2 in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetNewCoord2(CoordSwapAttributes::Coord(ival));
    else
    {
        fprintf(stderr, "An invalid newCoord2 value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Coord1, Coord2, Coord3.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CoordSwapAttributes_GetNewCoord2(PyObject *self, PyObject *args)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNewCoord2()));
    return retval;
}

static PyObject *
CoordSwapAttributes_SetNewCoord3(PyObject *self, PyObject *args)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the newCoord3 in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetNewCoord3(CoordSwapAttributes::Coord(ival));
    else
    {
        fprintf(stderr, "An invalid newCoord3 value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Coord1, Coord2, Coord3.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CoordSwapAttributes_GetNewCoord3(PyObject *self, PyObject *args)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNewCoord3()));
    return retval;
}



static struct PyMethodDef CoordSwapAttributes_methods[] = {
    {"Notify", CoordSwapAttributes_Notify, METH_VARARGS},
    {"SetNewCoord1", CoordSwapAttributes_SetNewCoord1, METH_VARARGS},
    {"GetNewCoord1", CoordSwapAttributes_GetNewCoord1, METH_VARARGS},
    {"SetNewCoord2", CoordSwapAttributes_SetNewCoord2, METH_VARARGS},
    {"GetNewCoord2", CoordSwapAttributes_GetNewCoord2, METH_VARARGS},
    {"SetNewCoord3", CoordSwapAttributes_SetNewCoord3, METH_VARARGS},
    {"GetNewCoord3", CoordSwapAttributes_GetNewCoord3, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
CoordSwapAttributes_dealloc(PyObject *v)
{
   CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
CoordSwapAttributes_compare(PyObject *v, PyObject *w)
{
    CoordSwapAttributes *a = ((CoordSwapAttributesObject *)v)->data;
    CoordSwapAttributes *b = ((CoordSwapAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
CoordSwapAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "newCoord1") == 0)
        return CoordSwapAttributes_GetNewCoord1(self, NULL);
    if(strcmp(name, "Coord1") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord1));
    else if(strcmp(name, "Coord2") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord2));
    else if(strcmp(name, "Coord3") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord3));

    if(strcmp(name, "newCoord2") == 0)
        return CoordSwapAttributes_GetNewCoord2(self, NULL);
    if(strcmp(name, "Coord1") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord1));
    else if(strcmp(name, "Coord2") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord2));
    else if(strcmp(name, "Coord3") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord3));

    if(strcmp(name, "newCoord3") == 0)
        return CoordSwapAttributes_GetNewCoord3(self, NULL);
    if(strcmp(name, "Coord1") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord1));
    else if(strcmp(name, "Coord2") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord2));
    else if(strcmp(name, "Coord3") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord3));


    return Py_FindMethod(CoordSwapAttributes_methods, self, name);
}

static int
CoordSwapAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "newCoord1") == 0)
        retval = (CoordSwapAttributes_SetNewCoord1(self, tuple) != NULL);
    else if(strcmp(name, "newCoord2") == 0)
        retval = (CoordSwapAttributes_SetNewCoord2(self, tuple) != NULL);
    else if(strcmp(name, "newCoord3") == 0)
        retval = (CoordSwapAttributes_SetNewCoord3(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
CoordSwapAttributes_print(PyObject *v, FILE *fp, int flags)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)v;

    const char *newCoord1_names = "Coord1, Coord2, Coord3";
    if(obj->data->GetNewCoord1() == CoordSwapAttributes::Coord1)
        fprintf(fp, "newCoord1 = Coord1  # %s\n", newCoord1_names);
    else if(obj->data->GetNewCoord1() == CoordSwapAttributes::Coord2)
        fprintf(fp, "newCoord1 = Coord2  # %s\n", newCoord1_names);
    else
        fprintf(fp, "newCoord1 = Coord3  # %s\n", newCoord1_names);

    const char *newCoord2_names = "Coord1, Coord2, Coord3";
    if(obj->data->GetNewCoord2() == CoordSwapAttributes::Coord1)
        fprintf(fp, "newCoord2 = Coord1  # %s\n", newCoord2_names);
    else if(obj->data->GetNewCoord2() == CoordSwapAttributes::Coord2)
        fprintf(fp, "newCoord2 = Coord2  # %s\n", newCoord2_names);
    else
        fprintf(fp, "newCoord2 = Coord3  # %s\n", newCoord2_names);

    const char *newCoord3_names = "Coord1, Coord2, Coord3";
    if(obj->data->GetNewCoord3() == CoordSwapAttributes::Coord1)
        fprintf(fp, "newCoord3 = Coord1  # %s\n", newCoord3_names);
    else if(obj->data->GetNewCoord3() == CoordSwapAttributes::Coord2)
        fprintf(fp, "newCoord3 = Coord2  # %s\n", newCoord3_names);
    else
        fprintf(fp, "newCoord3 = Coord3  # %s\n", newCoord3_names);


    return 0;
}

#include <snprintf.h>
PyObject *
PyCoordSwapAttributes_StringRepresentation(const CoordSwapAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    const char *newCoord1_names = "Coord1, Coord2, Coord3";
    if(atts->GetNewCoord1() == CoordSwapAttributes::Coord1)
        {
             SNPRINTF(tmpStr, 1000, "newCoord1 = Coord1  # %s\n", newCoord1_names);
             str += tmpStr;
        }
    else if(atts->GetNewCoord1() == CoordSwapAttributes::Coord2)
        {
             SNPRINTF(tmpStr, 1000, "newCoord1 = Coord2  # %s\n", newCoord1_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "newCoord1 = Coord3  # %s\n", newCoord1_names);
             str += tmpStr;
        }

    const char *newCoord2_names = "Coord1, Coord2, Coord3";
    if(atts->GetNewCoord2() == CoordSwapAttributes::Coord1)
        {
             SNPRINTF(tmpStr, 1000, "newCoord2 = Coord1  # %s\n", newCoord2_names);
             str += tmpStr;
        }
    else if(atts->GetNewCoord2() == CoordSwapAttributes::Coord2)
        {
             SNPRINTF(tmpStr, 1000, "newCoord2 = Coord2  # %s\n", newCoord2_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "newCoord2 = Coord3  # %s\n", newCoord2_names);
             str += tmpStr;
        }

    const char *newCoord3_names = "Coord1, Coord2, Coord3";
    if(atts->GetNewCoord3() == CoordSwapAttributes::Coord1)
        {
             SNPRINTF(tmpStr, 1000, "newCoord3 = Coord1  # %s\n", newCoord3_names);
             str += tmpStr;
        }
    else if(atts->GetNewCoord3() == CoordSwapAttributes::Coord2)
        {
             SNPRINTF(tmpStr, 1000, "newCoord3 = Coord2  # %s\n", newCoord3_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "newCoord3 = Coord3  # %s\n", newCoord3_names);
             str += tmpStr;
        }

    return PyString_FromString(str.c_str());
}

static PyObject *
CoordSwapAttributes_str(PyObject *v)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)v;
    return PyCoordSwapAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *CoordSwapAttributes_Purpose = "This class contains attributes for the coord swap operator.";

//
// The type description structure
//
static PyTypeObject CoordSwapAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "CoordSwapAttributes",                    // tp_name
    sizeof(CoordSwapAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)CoordSwapAttributes_dealloc,  // tp_dealloc
    (printfunc)CoordSwapAttributes_print,     // tp_print
    (getattrfunc)CoordSwapAttributes_getattr, // tp_getattr
    (setattrfunc)CoordSwapAttributes_setattr, // tp_setattr
    (cmpfunc)CoordSwapAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)CoordSwapAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    CoordSwapAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static CoordSwapAttributes *defaultAtts = 0;

static PyObject *
NewCoordSwapAttributes()
{
    CoordSwapAttributesObject *newObject;
    newObject = PyObject_NEW(CoordSwapAttributesObject, &CoordSwapAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new CoordSwapAttributes(*defaultAtts);
    else
        newObject->data = new CoordSwapAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapCoordSwapAttributes(const CoordSwapAttributes *attr)
{
    CoordSwapAttributesObject *newObject;
    newObject = PyObject_NEW(CoordSwapAttributesObject, &CoordSwapAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (CoordSwapAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
CoordSwapAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewCoordSwapAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef CoordSwapAttributesMethods[] = {
    {"CoordSwapAttributes", CoordSwapAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *CoordSwapAttributesObserver = 0;
static bool CoordSwapAttributesEnableLogging = true;

static void
PyCoordSwapAttributes_WriteLog(Subject *subj, void *data)
{
    CoordSwapAttributes *atts = (CoordSwapAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!CoordSwapAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# CoordSwapAttributes_WriteLog()\n");
}

void
PyCoordSwapAttributes_StartUp(CoordSwapAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyCoordSwapAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(CoordSwapAttributesObserver == 0)
    {
        CoordSwapAttributesObserver = new ObserverToCallback(subj,
            PyCoordSwapAttributes_WriteLog, (void *)logFile);
    }

    CoordSwapAttributesEnableLogging = true;
}

void
PyCoordSwapAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete CoordSwapAttributesObserver;
    CoordSwapAttributesObserver = 0;
}

PyMethodDef *
PyCoordSwapAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return CoordSwapAttributesMethods;
}

bool
PyCoordSwapAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &CoordSwapAttributesType);
}

CoordSwapAttributes *
PyCoordSwapAttributes_FromPyObject(PyObject *obj)
{
    CoordSwapAttributesObject *obj2 = (CoordSwapAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyCoordSwapAttributes_NewPyObject()
{
    return NewCoordSwapAttributes();
}

PyObject *
PyCoordSwapAttributes_WrapPyObject(const CoordSwapAttributes *attr)
{
    return WrapCoordSwapAttributes(attr);
}

void
PyCoordSwapAttributes_SetLogging(bool val)
{
    CoordSwapAttributesEnableLogging = val;
}

void
PyCoordSwapAttributes_SetDefaults(const CoordSwapAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new CoordSwapAttributes(*atts);
}

