// ************************************************************************* //
//  File: CoordSwapViewerPluginInfo.C
// ************************************************************************* //

#include <CoordSwapPluginInfo.h>
#include <CoordSwapAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo CoordSwap_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the CoordSwap operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    CoordSwapViewerPluginInfo::InitializeGlobalObjects();
    return new CoordSwapViewerPluginInfo;
}

//
// Storage for static data elements.
//
CoordSwapAttributes *CoordSwapViewerPluginInfo::clientAtts = NULL;
CoordSwapAttributes *CoordSwapViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  CoordSwapViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// ****************************************************************************
void
CoordSwapViewerPluginInfo::InitializeGlobalObjects()
{
    CoordSwapViewerPluginInfo::clientAtts  = new CoordSwapAttributes;
    CoordSwapViewerPluginInfo::defaultAtts = new CoordSwapAttributes;
}

// ****************************************************************************
//  Method: CoordSwapViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// ****************************************************************************

AttributeSubject *
CoordSwapViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: CoordSwapViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// ****************************************************************************

AttributeSubject *
CoordSwapViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: CoordSwapViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// ****************************************************************************

void
CoordSwapViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(CoordSwapAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: CoordSwapViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// ****************************************************************************

void
CoordSwapViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(CoordSwapAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: CoordSwapViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// ****************************************************************************

void
CoordSwapViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(CoordSwapAttributes*)atts = *defaultAtts;
    else
        *(CoordSwapAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: CoordSwapViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
// ****************************************************************************

#include <CoordSwap.xpm>
const char **
CoordSwapViewerPluginInfo::XPMIconData() const
{
    return CoordSwap_xpm;
}
